class TaskModification {
    Person person
    TaskModificationType taskModificationType
    Task task
    Date date = new Date()
    String comment = ""

    static belongsTo = [Person, TaskModificationType, Task]

    static constraints = {
        person()
        taskModificationType()
        task()
        date()
        comment()
    }

    String toString() {
        "${taskModificationType} on ${date.format('EEE, dd-MMM-yyyy')} by ${person}."
    }
}
