

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit InventoryLocation</title>
    </head>
    <body>
        <div class="nav">
            <span class="menuButton"><g:link class="list" action="list">InventoryLocation List</g:link></span>
            <span class="menuButton"><g:link class="create" action="create">New InventoryLocation</g:link></span>
        </div>
        <div class="body">
            <h1>Edit InventoryLocation</h1>
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${inventoryLocationInstance}">
            <div class="errors">
                <g:renderErrors bean="${inventoryLocationInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${inventoryLocationInstance?.id}" />
                <input type="hidden" name="version" value="${inventoryLocationInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryLocationInstance,field:'name','errors')}">
                                    <input type="text" maxlength="50" id="name" name="name" value="${fieldValue(bean:inventoryLocationInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryItems">Inventory Items:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryLocationInstance,field:'inventoryItems','errors')}">
                                    
<ul>
<g:each var="i" in="${inventoryLocationInstance?.inventoryItems?}">
    <li><g:link controller="inventoryItem" action="show" id="${i.id}">${i?.encodeAsHTML()}</g:link></li>
</g:each>
</ul>
<g:link controller="inventoryItem" params="['inventoryLocation.id':inventoryLocationInstance?.id]" action="create">Add InventoryItem</g:link>

                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryStore">Inventory Store:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryLocationInstance,field:'inventoryStore','errors')}">
                                    <g:select optionKey="id" from="${InventoryStore.list()}" name="inventoryStore.id" value="${inventoryLocationInstance?.inventoryStore?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryLocationInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${inventoryLocationInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
