import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class PeriodController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ periodInstanceList: Period.list( params ), periodInstanceTotal: Period.count() ]
    }

    def show = {
        def periodInstance = Period.get( params.id )

        if(!periodInstance) {
            flash.message = "Period not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ periodInstance : periodInstance ] }
    }

    def delete = {
        def periodInstance = Period.get( params.id )
        if(periodInstance) {
            try {
                periodInstance.delete(flush:true)
                flash.message = "Period ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "Period ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "Period not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def periodInstance = Period.get( params.id )

        if(!periodInstance) {
            flash.message = "Period not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ periodInstance : periodInstance ]
        }
    }

    def update = {
        def periodInstance = Period.get( params.id )
        if(periodInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(periodInstance.version > version) {
                    
                    periodInstance.errors.rejectValue("version", "period.optimistic.locking.failure", "Another user has updated this Period while you were editing.")
                    render(view:'edit',model:[periodInstance:periodInstance])
                    return
                }
            }
            periodInstance.properties = params
            if(!periodInstance.hasErrors() && periodInstance.save(flush: true)) {
                flash.message = "Period ${params.id} updated"
                redirect(action:show,id:periodInstance.id)
            }
            else {
                render(view:'edit',model:[periodInstance:periodInstance])
            }
        }
        else {
            flash.message = "Period not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def periodInstance = new Period()
        periodInstance.properties = params
        return ['periodInstance':periodInstance]
    }

    def save = {
        def periodInstance = new Period(params)
        if(!periodInstance.hasErrors() && periodInstance.save(flush: true)) {
            flash.message = "Period ${periodInstance.id} created"
            redirect(action:show,id:periodInstance.id)
        }
        else {
            render(view:'create',model:[periodInstance:periodInstance])
        }
    }
}
