

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Asset Search</title>
        <nav:resources override="true"/>
        <filterpane:includes />
        <export:resource />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <filterpane:currentCriteria domainBean="Asset"
                                    action="search"
                                    dateFormat="${'EEE, dd-MMM-yyyy'}"
                                    removeImgDir="images" 
                                    removeImgFile="bullet_delete.png"
                                    title="Search"/>

            <div class="paginateButtons">
                <span class="searchButtons">
                    <filterpane:filterButton text="Search" appliedText="Change Search" />
                </span>
                Results:${assetInstanceTotal}
            </div>

            <div class="list">
                <table>
                    <thead>
                        <tr>
                        
                   	        <g:sortableColumn property="id" title="Id" params="${filterParams}" />

                             <g:sortableColumn property="name" title="Name" params="${filterParams}" />
                        
                            <g:sortableColumn property="description" title="Description" params="${filterParams}" />

                            <g:sortableColumn property="isActive" title="Is Active" params="${filterParams}" />
                        
                            <g:sortableColumn property="section" title="Section" params="${filterParams}" />

                            <th></th>
                   	    
                        </tr>
                    </thead>
                    <tbody>
                    <g:each in="${assetInstanceList}" status="i" var="assetInstance">
                        <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/assetDetailed/show/${assetInstance.id}"'/>
                        
                            <td>${fieldValue(bean:assetInstance, field:'id')}</td>

                            <td>${fieldValue(bean:assetInstance, field:'name')}</td>                        

                            <td>${fieldValue(bean:assetInstance, field:'description')}</td>

                            <td>${fieldValue(bean:assetInstance, field:'isActive')}</td>

                            <td>${fieldValue(bean:assetInstance, field:'section')}</td>

                            <td>
                                <g:link action="show" id="${assetInstance.id}">
                                    <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                </g:link>
                            </td>
                        
                        </tr>
                    </g:each>
                    </tbody>
                </table>
            </div>
            <div class="paginateButtons">
                <g:paginate total="${assetInstanceTotal}" params="${filterParams}" />
            </div>
            <export:formats  params="${filterParams}" formats="['csv', 'excel', 'pdf', 'rtf']"/>
            <br />
            Asset Tree:
            <g:link action="exportAssetTree">
                Export
            </g:link>
            /
            <g:link action="exportAssetTreeTemplate">
                Template
            </g:link>
            /
            <g:link action="importAssetTree">
                Import
            </g:link>

            <filterpane:filterPane domainBean="Asset"
                                    title="Search"
                                    action="search"
                                    class="overlayPane"
                                    excludeProperties=""
                                    associatedProperties="section.name"
                                    filterPropertyValues="${['section.name':[values:Section.list()] ]}" />
        </div> <!-- end body div -->
    </body>
</html>
