class AssignedPersonService {

    boolean transactional = false

    def personService

    def delete(params) {
        AssignedPerson.withTransaction { status ->
            def result = [:]

            def fail = { Map m ->
                status.setRollbackOnly()
                if(result.assignedPersonInstance && m.field)
                    result.assignedPersonInstance.errors.rejectValue(m.field, m.code)
                result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
                return result
            }

            result.assignedPersonInstance = AssignedPerson.get(params.id)

            if(!result.assignedPersonInstance)
                return fail(code:"default.not.found")

            def taskModification = new TaskModification(person: personService.currentUser,
                                                    taskModificationType: TaskModificationType.get(11),
                                                    task: result.assignedPersonInstance.task)

            if(!taskModification.save())
                return fail(field:"taskModifications", code:"task.modifications.failedToSave")

            try {
                result.assignedPersonInstance.delete(flush:true)
                return result //Success.
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                return fail(code:"default.delete.failure")
            }

        } //end withTransaction
    } // end delete()

    def edit(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
            return result
        }

        result.assignedPersonInstance = AssignedPerson.get(params.id)

        if(!result.assignedPersonInstance)
            return fail(code:"default.not.found")

        result.person = result.assignedPersonInstance.person
        result.groupsForPerson = result.person.personGroups.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }

        // Success.
        return result
    }

    def update(params) {
        AssignedPerson.withTransaction { status ->
            def result = [:]

            def fail = { Map m ->
                status.setRollbackOnly()
                if(result.assignedPersonInstance && m.field)
                    result.assignedPersonInstance.errors.rejectValue(m.field, m.code)
                result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
                return result
            }

            result.person = Person.get(params.person.id)

            // Prevent a null property reference.
            if(!result.person)
                return fail(code:"person.not.found")

            result.groupsForPerson = result.person.personGroups.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }

            result.assignedPersonInstance = AssignedPerson.get(params.id)

            if(!result.assignedPersonInstance)
                return fail(code:"default.not.found")

            // Optimistic locking check.
            if(params.version) {
                if(result.assignedPersonInstance.version > params.version.toLong())
                    return fail(field:"version", code:"default.optimistic.locking.failure")
            }

            result.assignedPersonInstance.properties = params

            if(result.assignedPersonInstance.hasErrors() || !result.assignedPersonInstance.save())
                return fail(code:"default.update.failure")

            def taskModification = new TaskModification(person: personService.currentUser,
                                                    taskModificationType: TaskModificationType.get(11),
                                                    task: result.assignedPersonInstance.task)

            if(!taskModification.save())
                return fail(field:"taskModifications", code:"task.modifications.failedToSave")

            // Success.
            return result

        } //end withTransaction
    }  // end update()

    def create(params) {
        def result = [:]
        def fail = { Map m ->
            result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
            return result
        }

        if(!params.task?.id)
            fail(code:"assignedPerson.task.not.found")

        result.assignedPersonInstance = new AssignedPerson()
        result.assignedPersonInstance.properties = params

        result.person = Person.list().sort { p1, p2 -> p1.firstName.compareToIgnoreCase(p2.firstName) }[0] // Get the first result.
        result.groupsForPerson = result.person.personGroups.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }

        // Success.
        return result
    }

    def save(params) {
        AssignedPerson.withTransaction { status ->
            def result = [:]

            def fail = { Map m ->
                status.setRollbackOnly()
                if(result.assignedPersonInstance && m.field)
                    result.assignedPersonInstance.errors.rejectValue(m.field, m.code)
                result.error = [ code: m.code, args: ["AssignedPerson", params.id] ]
                return result
            }

            result.person = Person.get(params.person.id)

            // Prevent a null property reference.
            if(!result.person)
                return fail(code:"person.not.found")

            result.groupsForPerson = result.person.personGroups.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }

            result.assignedPersonInstance = new AssignedPerson()
            result.assignedPersonInstance.properties = params

            if(result.assignedPersonInstance.hasErrors() || !result.assignedPersonInstance.save())
                return fail(code:"default.create.failure")

            // Record a taskModification for every one except "system".
            if(personService.currentUser.id != 1) {
                def taskModification = new TaskModification(person: personService.currentUser,
                                                        taskModificationType: TaskModificationType.get(11),
                                                        task: result.assignedPersonInstance.task)

                if(!taskModification.save())
                    return fail(field:"taskModifications", code:"task.modifications.failedToSave")
            }

            // success
            return result

        } //end withTransaction
    } // end save()

    def groupsForPerson(params) {
        def result = [:]

        def fail = { Map m ->
            result.error = [ code: m.code, args: ["Person", params.person?.id] ]
            return result
        }

        result.person = Person.get(params.person?.id)

        if(!result.person)
            return fail(code:"default.not.found")

        result.groupsForPerson = result.person.personGroups.sort { p1, p2 -> p1.name.compareToIgnoreCase(p2.name) }

        // Success.
        return result
    }

} // end class