import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AssignedGroupDetailedController extends BaseController {

    def assignedGroupService

    def index = {
        flash.message = g.message(code: "assignedGroup.task.not.found")
        redirect(controller:"taskDetailed", action:"search")
    }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def delete = {
        def result = assignedGroupService.delete(params)

        if(!result.error) {
            flash.message = g.message(code: "default.delete.success", args: ["AssignedGroup", params.id])
            redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
            return
        }

        flash.message = g.message(code: result.error.code, args: result.error.args)

        if(result.error.code == "default.not.found") {
            redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
            return
        }

        redirect(action:show, id: params.id)
    }

    def edit = {
        def result = assignedGroupService.edit(params)

        if(!result.error) {
            return [assignedGroupInstance: result.assignedGroupInstance,
                            personGroup: result.personGroup,
                            personsInGroup: result.personsInGroup]
        }

        flash.message = g.message(code: result.error.code, args: result.error.args)

        redirect(controller:"taskDetailed", action:"show", id: params.task?.id)

    }

    def update = {
        def result = assignedGroupService.update(params)

        if(!result.error) {
            flash.message = g.message(code: "default.update.success", args: ["AssignedGroup", params.id])
            redirect(controller:"taskDetailed", action:"show", id: result.assignedGroupInstance.task.id)
            return
        }

        if(result.error.code == "default.not.found") {
            flash.message = g.message(code: result.error.code, args: result.error.args)
            redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
            return
        }

        if(result.error.code == "personGroup.not.found") {
            flash.message = g.message(code: result.error.code, args: result.error.args)
            redirect(action:"edit", id: params.id)
            return
        }

        render(view:'edit', model:[assignedGroupInstance: result.assignedGroupInstance.attach(),
                                                personGroup: result.personGroup.attach(),
                                                personsInGroup: result.personsInGroup])
    }

    def create = {
        def result = assignedGroupService.create(params)

        if(!result.error) {
            return [assignedGroupInstance: result.assignedGroupInstance,
                            personGroup: result.personGroup,
                            personsInGroup: result.personsInGroup]
        }

        if(result.error.code == "assignedGroup.task.not.found") {
            flash.message = g.message(code: result.error.code, args: result.error.args)
            redirect(controller: "taskDetailed", action: "search")
            return
        }

        flash.message = g.message(code: result.error.code, args: result.error.args)
        redirect(controller:"taskDetailed", action:"show", id: params.task?.id)
    }

    def save = {
        def result = assignedGroupService.save(params)

        if(!result.error) {
            flash.message = g.message(code: "default.create.success", args: ["AssignedGroup", result.assignedGroupInstance.id])
            redirect(controller:"taskDetailed", action:"show", id: result.assignedGroupInstance.task.id)
            return
        }

        if(result.error.code == "personGroup.not.found") {
            flash.message = g.message(code: result.error.code, args: result.error.args)
            redirect(action:"create", params:["task.id": params.task?.id])
            return
        }

        render(view:'create', model:[assignedGroupInstance: result.assignedGroupInstance,
                                                personGroup: result.personGroup.attach(),
                                                personsInGroup: result.personsInGroup])
    }

    def personsInGroup = {
        def result = assignedGroupService.personsInGroup(params)

        if(!result.error) {
            render ( template:"personsInGroup",
                            model: [personGroup: result.personGroup, personsInGroup: result.personsInGroup] )
            return
        }

        render {
            div(id:"personsInGroup", g.message(code: result.error.code, args: result.error.args) )
        }

    }

}
