class Asset {

    SystemSection systemSection
    AssetType assetType

    String name
    String description = ""
    String costCode = ""
    boolean isActive = true

    static hasMany = [maintenanceActions: MaintenanceAction,
                                    assetExtendedAttributes: AssetExtendedAttribute]

    static belongsTo = [SystemSection, AssetType]

    static constraints = {
        name(unique:true, blank:false)
    }

    String toString() {
        "${this.name}"
    }
}

