import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class TaskRecurringScheduleDetailedController extends BaseController {

    def taskRecurringScheduleService

    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ taskRecurringScheduleInstanceList: TaskRecurringSchedule.list( params ), taskRecurringScheduleInstanceTotal: TaskRecurringSchedule.count() ]
    }

    def show = {
        def taskRecurringScheduleInstance = TaskRecurringSchedule.get( params.id )

        if(!taskRecurringScheduleInstance) {
            flash.message = "Recurring Schedule not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskRecurringScheduleInstance : taskRecurringScheduleInstance ] }
    }

    def delete = {
        def taskRecurringScheduleInstance = TaskRecurringSchedule.get( params.id )
        if(taskRecurringScheduleInstance) {
            try {
                taskRecurringScheduleInstance.delete(flush: true)
                flash.message = "Recurring Schedule ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "Recurring Schedule ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "Recurring Schedule not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def taskRecurringScheduleInstance = TaskRecurringSchedule.get( params.id )

        if(!taskRecurringScheduleInstance) {
            flash.message = "Recurring Schedule not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskRecurringScheduleInstance : taskRecurringScheduleInstance]
        }
    }

    def update = {

        if(!TaskRecurringSchedule.exists(params.id)) {
            flash.message = "Recurring Schedule not found with id ${params.id}"
            redirect(action: 'list')
        }

        def result = taskRecurringScheduleService.update(params)

        if(!result.error) {
                flash.message = "Recurring Schedule ${params.id} updated"
                redirect(action: 'show', id: result.taskRecurringScheduleInstance.id)
        }
        else {
            render(view:'edit',model:[taskRecurringScheduleInstance: result.taskRecurringScheduleInstance.attach()])
        }

    }

    def create = {
        if(!params.task?.id || !Task.exists(params.task?.id)) {
            flash.message = "Please select a task, then Create a Recurring Schedule for it."
            redirect(controller:"taskDetailed", action:"search")
            return
        }
        def taskRecurringScheduleInstance = new TaskRecurringSchedule()
        taskRecurringScheduleInstance.properties = params
        return [taskRecurringScheduleInstance: taskRecurringScheduleInstance]
    } // end create()

    def save = {
        def result = taskRecurringScheduleService.create(params)

        if(!result.error) {
            flash.message = "Recurring Schedule ${result.taskRecurringScheduleInstance.id} created."
            redirect(action:show, id: result.taskRecurringScheduleInstance.id)
        }
        else {
            render(view:'create',model:[taskRecurringScheduleInstance: result.taskRecurringScheduleInstance])
        }
    } // end save()

}
