

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Create InventoryMovement</title>
        <g:javascript src="overlayPane.js" />
    </head>
    <body>
        <div class="nav">
            <h1>Create Inventory Movement</h1>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <g:hasErrors bean="${inventoryMovementInstance}">
            <div class="errors">
                <g:renderErrors bean="${inventoryMovementInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form action="save" method="post" >
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryItem">Inventory Item:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryMovementInstance,field:'inventoryItem','errors')}">
                                    <g:select optionKey="id" from="${InventoryItem.list()}" name="inventoryItem.id" value="${inventoryMovementInstance?.inventoryItem?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="quantity">Quantity:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryMovementInstance,field:'quantity','errors')}">
                                    <input type="text" id="quantity" name="quantity" value="${fieldValue(bean:inventoryMovementInstance,field:'quantity')}"/>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryMovementType">Movement Type:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:inventoryMovementInstance,field:'inventoryMovementType','errors')}">
                                    <g:select optionKey="id" from="${InventoryMovementType.list()}" name="inventoryMovementType.id" value="${inventoryMovementInstance?.inventoryMovementType?.id}" ></g:select>
                                </td>
                            </tr>

                            <g:if test="${inventoryMovementInstance.task}">
                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="taskInstance">Linking with Task:</label>
                                    </td>
                                    <td valign="top" name="inventoryMovementInstance.task" class="value">
                                        <g:hiddenField name="task.id" value="${inventoryMovementInstance.task.id}" />
                                        <g:link controller="taskDetailed" action="show" id="${inventoryMovementInstance.task.id}" >
                                            ${inventoryMovementInstance.task}
                                        </g:link>
                                    </td>
                                </tr>
                            </g:if>

                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:form>
        </div>


        <!-- Start Search Pane -->
        <div class="overlayPane" id="searchPane" style="display:none;">
            <h2>Quick Search</h2>
            <g:form method="post" id="searchForm" name="searchForm" >
                <table>
                    <tbody>

                        <tr class="prop">
                            <td valign="top" class="name">
                                <label>My Tasks:</label>
                            </td>
                            <td valign="top" class="value">
                                <g:link controller="taskDetailed"
                                                action="search"
                                                params="[quickSearch: 'searchMyTodays']">
                                                Today's
                                </g:link>
                                <br />
                                <g:link controller="taskDetailed" 
                                                action="search"
                                                params="[quickSearch: 'searchMyInTheLastWeek']">
                                                In the last week
                                </g:link>
                            </td>
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">
                                <label>Tasks:</label>
                            </td>
                            <td valign="top" class="value">
                                <g:link controller="taskDetailed"
                                                action="search"
                                                params="[quickSearch: 'searchTodays']">
                                                Today's
                                </g:link>
                                <br />
                                <g:link controller="taskDetailed" 
                                                action="search"
                                                params="[quickSearch: 'searchInTheLastWeek']">
                                                In the last week
                                </g:link>
                            </td>
                        </tr>

                    </tbody>
                </table>
                <div class="buttons">
                    <span class="button">
                        <input type="button" value="${g.message(code:'fp.tag.filterPane.button.cancel.text', default:'Cancel')}" onclick="return hideElement('searchPane');" />
                    </span>
<!--                    <span class="button">
                        <input type="button" value="${g.message(code:'fp.tag.filterPane.button.clear.text', default:'Clear')}" onclick="return clearFilterPane('searchForm');" />
                    </span>
                    <span class="button">
                        <g:actionSubmit class="search" value="Search" />
                    </span>-->
                </div>
            </g:form>
        </div> <!-- end search pane -->

    </body>
</html>
