import java.text.SimpleDateFormat

class TaskModification {
    Person person
    TaskModificationType taskModificationType
    Task task
    Date date = new Date()
    String comment = ""

    static belongsTo = [Person, TaskModificationType, Task]

    static constraints = {
        person()
        taskModificationType()
        task()
        date()
        comment()
    }

    String toString() {
        def date = new SimpleDateFormat("EEE, dd-MMM-yyyy").format(this.date)
        "${taskModificationType} on ${date} by ${person}."
    }
}
