class Person {
    String firstName
    String lastName
    Integer employeeID
    boolean isActive = true

    static hasMany = [modifications : Modification,
                        entries : Entry]

    static belongsTo = Entry

    static optionals = ["employeeID"]

    static constraints = {
        firstName()
        lastName()
        employeeID()
    }

    //Overriding the default toString method
    String toString() {"${this.firstName}:"{this.lastName}}
}
