

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>InventoryItem Search</title>
        <nav:resources override="true"/>
        <filterpane:includes />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <filterpane:currentCriteria domainBean="InventoryItem"
                                    action="search"
                                    dateFormat="${'EEE, dd-MMM-yyyy'}"
                                    removeImgDir="images" 
                                    removeImgFile="bullet_delete.png"
                                    title="Search"/>

            <div class="paginateButtons">
                <filterpane:filterButton text="Search" appliedText="Change Search" />
                Results:${inventoryItemInstanceTotal}
            </div>

            <div class="list">
                <table>
                    <thead>
                        <tr>
                        
                   	        <g:sortableColumn property="id" title="Id" params="${filterParams}" />
                        
                   	        <g:sortableColumn property="name" title="Name" params="${filterParams}" />
                        
                   	        <g:sortableColumn property="description" title="Description" params="${filterParams}" />
                        
                            <g:sortableColumn property="unitsInStock" title="Units In Stock" />
                            
                            <th>Unit Of Measure</th>

                            <th></th>
                        
                        </tr>
                    </thead>
                    <tbody>
                    <g:each in="${inventoryItemInstanceList}" status="i" var="inventoryItemInstance">
                        <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/inventoryItemDetailed/show/${inventoryItemInstance.id}"'/>
                        
                            <td>${fieldValue(bean:inventoryItemInstance, field:'id')}</td>
                        
                            <td>${fieldValue(bean:inventoryItemInstance, field:'name')}</td>
                        
                            <td>${fieldValue(bean:inventoryItemInstance, field:'description')}</td>
                        
                            <td>${fieldValue(bean:inventoryItemInstance, field:'unitsInStock')}</td>
                        
                            <td>${fieldValue(bean:inventoryItemInstance, field:'unitOfMeasure')}</td>

                            <td>
                                <g:link action="show" id="${inventoryItemInstance.id}">
                                    <img  src="${resource(dir:'images/skin',file:'database_table.png')}" alt="Show" />
                                </g:link>
                            </td>
                        
                        </tr>
                    </g:each>
                    </tbody>
                </table>
            </div>
            <div class="paginateButtons">
                <g:paginate total="${inventoryItemInstanceTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="InventoryItem"
                                    title="Search"
                                    action="search"
                                    class="overlayPane"
                                    excludeProperties=""
                                    associatedProperties="inventoryLocation.name,
                                                                            spareFor.name,
                                                                            manufacturers.name,
                                                                            suppliers.name"
                                    filterPropertyValues="${['inventoryLocation.name':[values:InventoryLocation.list()],
                                                                                'spareFor.name':[values:Asset.list()],
                                                                                'manufacturers.name':[values:Manufacturer.list()],
                                                                                'suppliers.name':[values:Supplier.list()],
                                                                                ]}"/>
        </div> <!-- end body div -->
    </body>
</html>
