import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class DepartmentController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ departmentInstanceList: Department.list( params ), departmentInstanceTotal: Department.count() ]
    }

    def show = {
        def departmentInstance = Department.get( params.id )

        if(!departmentInstance) {
            flash.message = "Department not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ departmentInstance : departmentInstance ] }
    }

    def delete = {
        def departmentInstance = Department.get( params.id )
        if(departmentInstance) {
            try {
                departmentInstance.delete(flush:true)
                flash.message = "Department ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "Department ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "Department not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def departmentInstance = Department.get( params.id )

        if(!departmentInstance) {
            flash.message = "Department not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ departmentInstance : departmentInstance ]
        }
    }

    def update = {
        def departmentInstance = Department.get( params.id )
        if(departmentInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(departmentInstance.version > version) {
                    
                    departmentInstance.errors.rejectValue("version", "department.optimistic.locking.failure", "Another user has updated this Department while you were editing.")
                    render(view:'edit',model:[departmentInstance:departmentInstance])
                    return
                }
            }
            departmentInstance.properties = params
            if(!departmentInstance.hasErrors() && departmentInstance.save()) {
                flash.message = "Department ${params.id} updated"
                redirect(action:show,id:departmentInstance.id)
            }
            else {
                render(view:'edit',model:[departmentInstance:departmentInstance])
            }
        }
        else {
            flash.message = "Department not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def departmentInstance = new Department()
        departmentInstance.properties = params
        return ['departmentInstance':departmentInstance]
    }

    def save = {
        def departmentInstance = new Department(params)
        if(!departmentInstance.hasErrors() && departmentInstance.save()) {
            flash.message = "Department ${departmentInstance.id} created"
            redirect(action:show,id:departmentInstance.id)
        }
        else {
            render(view:'create',model:[departmentInstance:departmentInstance])
        }
    }
}
