import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class PersonGroupTypeController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ personGroupTypeInstanceList: PersonGroupType.list( params ), personGroupTypeInstanceTotal: PersonGroupType.count() ]
    }

    def show = {
        def personGroupTypeInstance = PersonGroupType.get( params.id )

        if(!personGroupTypeInstance) {
            flash.message = "PersonGroupType not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ personGroupTypeInstance : personGroupTypeInstance ] }
    }

    def delete = {
        def personGroupTypeInstance = PersonGroupType.get( params.id )
        if(personGroupTypeInstance) {
            try {
                personGroupTypeInstance.delete()
                flash.message = "PersonGroupType ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "PersonGroupType ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "PersonGroupType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def personGroupTypeInstance = PersonGroupType.get( params.id )

        if(!personGroupTypeInstance) {
            flash.message = "PersonGroupType not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ personGroupTypeInstance : personGroupTypeInstance ]
        }
    }

    def update = {
        def personGroupTypeInstance = PersonGroupType.get( params.id )
        if(personGroupTypeInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(personGroupTypeInstance.version > version) {
                    
                    personGroupTypeInstance.errors.rejectValue("version", "personGroupType.optimistic.locking.failure", "Another user has updated this PersonGroupType while you were editing.")
                    render(view:'edit',model:[personGroupTypeInstance:personGroupTypeInstance])
                    return
                }
            }
            personGroupTypeInstance.properties = params
            if(!personGroupTypeInstance.hasErrors() && personGroupTypeInstance.save()) {
                flash.message = "PersonGroupType ${params.id} updated"
                redirect(action:show,id:personGroupTypeInstance.id)
            }
            else {
                render(view:'edit',model:[personGroupTypeInstance:personGroupTypeInstance])
            }
        }
        else {
            flash.message = "PersonGroupType not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def personGroupTypeInstance = new PersonGroupType()
        personGroupTypeInstance.properties = params
        return ['personGroupTypeInstance':personGroupTypeInstance]
    }

    def save = {
        def personGroupTypeInstance = new PersonGroupType(params)
        if(!personGroupTypeInstance.hasErrors() && personGroupTypeInstance.save()) {
            flash.message = "PersonGroupType ${personGroupTypeInstance.id} created"
            redirect(action:show,id:personGroupTypeInstance.id)
        }
        else {
            render(view:'create',model:[personGroupTypeInstance:personGroupTypeInstance])
        }
    }
}
