

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Asset Search</title>
        <nav:resources override="true"/>
        <filterpane:includes />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:if test="${flash.message}">
            <div class="message">${flash.message}</div>
            </g:if>
            <filterpane:currentCriteria domainBean="Asset"
                                    action="search"
                                    dateFormat="${'EEE, dd-MMM-yyyy'}"
                                    removeImgDir="images" 
                                    removeImgFile="bullet_delete.png"
                                    title="Search"/>

            <div class="paginateButtons">
                <filterpane:filterButton text="Search" appliedText="Change Search" />
                Results:${assetInstanceTotal}
            </div>

            <div class="list">
                <table>
                    <thead>
                        <tr>
                        
                   	        <g:sortableColumn property="id" title="Id" params="${filterParams}" />

                             <g:sortableColumn property="name" title="Name" params="${filterParams}" />

                             <g:sortableColumn property="assetType" title="Asset Type" params="${filterParams}" />
                        
                   	        <g:sortableColumn property="systemSection" title="System Section" params="${filterParams}" />

                            <g:sortableColumn property="isActive" title="Is Active" params="${filterParams}" />

                            <th></th>
                   	    
                        </tr>
                    </thead>
                    <tbody>
                    <g:each in="${assetInstanceList}" status="i" var="assetInstance">
                        <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" onclick='window.location = "${request.getContextPath()}/assetDetailed/show/${assetInstance.id}"'/>
                        
                            <td>${fieldValue(bean:assetInstance, field:'id')}</td>

                            <td>${fieldValue(bean:assetInstance, field:'name')}</td>                        

                            <td>${fieldValue(bean:assetInstance, field:'assetType')}</td>

                            <td>${fieldValue(bean:assetInstance, field:'systemSection')}</td>

                            <td>${fieldValue(bean:assetInstance, field:'isActive')}</td>

                            <td>
                                <g:link action="show" id="${assetInstance.id}">
                                    <img  src="${resource(dir:'images/skin',file:'database_table.png')}" alt="Show" />
                                </g:link>
                            </td>
                        
                        </tr>
                    </g:each>
                    </tbody>
                </table>
            </div>
            <div class="paginateButtons">
                <g:paginate total="${assetInstanceTotal}" params="${filterParams}" />
            </div>

            <filterpane:filterPane domainBean="Asset"
                                    title="Search"
                                    action="search"
                                    class="overlayPane"
                                    excludeProperties=""
                                    associatedProperties="systemSection.name, assetType.name"
                                    filterPropertyValues="${['systemSection.name':[values:SystemSection.list()],
                                                                        'assetType.name':[values:AssetType.list()] ]}" />
        </div> <!-- end body div -->
    </body>
</html>
