// locations to search for config files that get merged into the main config
// config files can either be Java properties files or ConfigSlurper scripts

// grails.config.locations = [ "classpath:${appName}-config.properties",
//                             "classpath:${appName}-config.groovy",
//                             "file:${userHome}/.grails/${appName}-config.properties",
//                             "file:${userHome}/.grails/${appName}-config.groovy"]

// if(System.properties["${appName}.config.location"]) {
//    grails.config.locations << "file:" + System.properties["${appName}.config.location"]
// }
grails.mime.file.extensions = true // enables the parsing of file extensions from URLs into the request format
grails.mime.types = [ html: ['text/html','application/xhtml+xml'],
                      xml: ['text/xml', 'application/xml'],
                      text: 'text-plain',
                      js: 'text/javascript',
                      rss: 'application/rss+xml',
                      atom: 'application/atom+xml',
                      css: 'text/css',
                      csv: 'text/csv',
                      all: '*/*',
                      json: ['application/json','text/json'],
                      form: 'application/x-www-form-urlencoded',
                      multipartForm: 'multipart/form-data'
                    ]
// The default codec used to encode data with ${}
grails.views.default.codec="none" // none, html, base64
grails.views.gsp.encoding="UTF-8"
grails.converters.encoding="UTF-8"

// enabled native2ascii conversion of i18n properties files
grails.enable.native2ascii = true

// set per-environment serverURL stem for creating absolute links
environments {
    production {
        grails.serverURL = "http://www.changeme.com"
    }
}

// log4j configuration
log4j {
    appender.stdout = "org.apache.log4j.ConsoleAppender"
    appender.'stdout.layout'="org.apache.log4j.PatternLayout"
    appender.'stdout.layout.ConversionPattern'='[%r] %c{2} %m%n'
    appender.stacktraceLog = "org.apache.log4j.FileAppender"
    appender.'stacktraceLog.layout'="org.apache.log4j.PatternLayout"
    appender.'stacktraceLog.layout.ConversionPattern'='[%r] %c{2} %m%n'
    appender.'stacktraceLog.File'="stacktrace.log"
    rootLogger="error,stdout"
    logger {
        grails="error"
        StackTrace="error,stacktraceLog"
        org {
            codehaus.groovy.grails.web.servlet="error"  //  controllers
            codehaus.groovy.grails.web.pages="error" //  GSP
            codehaus.groovy.grails.web.sitemesh="error" //  layouts
            codehaus.groovy.grails."web.mapping.filter"="error" // URL mapping
            codehaus.groovy.grails."web.mapping"="error" // URL mapping
            codehaus.groovy.grails.commons="info" // core / classloading
            codehaus.groovy.grails.plugins="error" // plugins
            codehaus.groovy.grails.orm.hibernate="error" // hibernate integration
            springframework="off"
            hibernate="off"
        }
    }
    additivity.StackTrace=false
}

//log4j.logger.org.springframework.security='off,stdout'

/** Navigation plugin menu.
   * The top level titles are taken from i18n message bundles.
   * Subitems i18n message bundles are not currently resolving with this plugin.
   */
navigation.nav = [
    [order:10, controller:'appCore', title:'home', action:'start',
        subItems: [
            [order:10, controller:'appCore', title:'Start', action:'start', isVisible: { true }],
            [order:20, controller:'appCore', title:'Manager', action:'manager', isVisible: { authenticateService.ifAllGranted('ROLE_Manager') }],
            [order:30, controller:'appCore', title:'Admin', action:'appAdmin', isVisible: { authenticateService.ifAllGranted('ROLE_AppAdmin') }],
            [order:90, controller:'appCore', title:'Timeout', action:'changeSessionTimeout', isVisible: { params.action == 'changeSessionTimeout' }],
            [order:91, controller:'appCore', title:'Password', action:'changePassword', isVisible: { params.action == 'changePassword' }],
        ]
    ],
    [order:20, controller:'taskDetailed', title:'tasks', action:'search',
        subItems: [
            [order:10, controller:'taskDetailed', title:'Search', action:'search', isVisible: { params.action != 'advancedSearch'}],
            [order:11, controller:'taskDetailed', title:'Advanced Search', action:'advancedSearch', isVisible: { params.action == 'advancedSearch' }],
            [order:20, controller:'taskDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'taskDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'taskDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:30, controller:'inventoryItemDetailed', title:'inventory', action:'search',
        subItems: [
            [order:10, controller:'inventoryItemDetailed', title:'Search', action:'search', isVisible: { true }],
            [order:20, controller:'inventoryItemDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'inventoryItemDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'inventoryItemDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:40, controller:'assetDetailed', title:'assets', action:'search',
        subItems: [
            [order:10, controller:'assetDetailed', title:'Search', action:'search', isVisible: { true }],
            [order:20, controller:'assetDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'assetDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'assetDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ]
]

/** Navigation plugin alternate menu.
   * The alternate top level titles are not displayed anywhere.
   * Subitems i18n message bundles are not currently resolving with this plugin.
   */
navigation.navAlt = [
    [order:10, controller:'person', title:'person', action:'list',
        subItems: [
            [order:10, controller:'person', title:'Person List', action:'list', isVisible: { true }],
            [order:20, controller:'person', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'person', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'person', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ],
    [order:20, controller:'taskProcedureDetailed', title:'task', action:'list',
        subItems: [
            [order:10, controller:'taskProcedureDetailed', title:'Task Procedure List', action:'list', isVisible: { true }],
            [order:20, controller:'taskProcedureDetailed', title:'Create', action:'create', isVisible: { true }],
            [order:90, controller:'taskProcedureDetailed', title:'Show', action:'show', isVisible: { params.action == 'show' }],
            [order:91, controller:'taskProcedureDetailed', title:'Edit', action:'edit', isVisible: { params.action == 'edit' }]
        ]
    ]
]
