import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AssignedPersonDetailedController extends BaseController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ assignedPersonInstanceList: AssignedPerson.list( params ), assignedPersonInstanceTotal: AssignedPerson.count() ]
    }

    def show = {
        def assignedPersonInstance = AssignedPerson.get( params.id )

        if(!assignedPersonInstance) {
            flash.message = "AssignedPerson not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ assignedPersonInstance : assignedPersonInstance ] }
    }

    def delete = {
        def assignedPersonInstance = AssignedPerson.get( params.id )
        if(assignedPersonInstance) {
            try {
                assignedPersonInstance.delete()
                flash.message = "AssignedPerson ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "AssignedPerson ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "AssignedPerson not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def assignedPersonInstance = AssignedPerson.get( params.id )

        if(!assignedPersonInstance) {
            flash.message = "AssignedPerson not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ assignedPersonInstance : assignedPersonInstance ]
        }
    }

    def update = {
        def assignedPersonInstance = AssignedPerson.get( params.id )
        if(assignedPersonInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(assignedPersonInstance.version > version) {
                    
                    assignedPersonInstance.errors.rejectValue("version", "assignedPerson.optimistic.locking.failure", "Another user has updated this AssignedPerson while you were editing.")
                    render(view:'edit',model:[assignedPersonInstance:assignedPersonInstance])
                    return
                }
            }
            assignedPersonInstance.properties = params
            if(!assignedPersonInstance.hasErrors() && assignedPersonInstance.save()) {
                flash.message = "AssignedPerson ${params.id} updated"
                redirect(action:show,id:assignedPersonInstance.id)
            }
            else {
                render(view:'edit',model:[assignedPersonInstance:assignedPersonInstance])
            }
        }
        else {
            flash.message = "AssignedPerson not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
		if(!params.task?.id) {
			flash.message = "Please select a task and then 'Add Assigned Person'"
			redirect(controller: "taskDetailed", action: list)
		}
		else {
        def assignedPersonInstance = new AssignedPerson()
        assignedPersonInstance.properties = params
        return ['assignedPersonInstance':assignedPersonInstance]
		}
    }

    def save = {
        def assignedPersonInstance = new AssignedPerson(params)
        if(!assignedPersonInstance.hasErrors() && assignedPersonInstance.save()) {
            flash.message = "AssignedPerson ${assignedPersonInstance.id} created"
            redirect(action:show,id:assignedPersonInstance.id)
        }
        else {
            render(view:'create',model:[assignedPersonInstance:assignedPersonInstance])
        }
    }
}
