import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class FormController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ formInstanceList: Form.list( params ), formInstanceTotal: Form.count() ]
    }

    def show = {
        def formInstance = Form.get( params.id )

        if(!formInstance) {
            flash.message = "Form not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ formInstance : formInstance ] }
    }

    def delete = {
        def formInstance = Form.get( params.id )
        if(formInstance) {
            try {
                formInstance.delete()
                flash.message = "Form ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "Form ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "Form not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def formInstance = Form.get( params.id )

        if(!formInstance) {
            flash.message = "Form not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ formInstance : formInstance ]
        }
    }

    def update = {
        def formInstance = Form.get( params.id )
        if(formInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(formInstance.version > version) {
                    
                    formInstance.errors.rejectValue("version", "form.optimistic.locking.failure", "Another user has updated this Form while you were editing.")
                    render(view:'edit',model:[formInstance:formInstance])
                    return
                }
            }
            formInstance.properties = params
            if(!formInstance.hasErrors() && formInstance.save()) {
                flash.message = "Form ${params.id} updated"
                redirect(action:show,id:formInstance.id)
            }
            else {
                render(view:'edit',model:[formInstance:formInstance])
            }
        }
        else {
            flash.message = "Form not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def formInstance = new Form()
        formInstance.properties = params
        return ['formInstance':formInstance]
    }

    def save = {
        def formInstance = new Form(params)
        if(!formInstance.hasErrors() && formInstance.save()) {
            flash.message = "Form ${formInstance.id} created"
            redirect(action:show,id:formInstance.id)
        }
        else {
            render(view:'create',model:[formInstance:formInstance])
        }
    }
}
