import static org.junit.Assert.assertThat
import static org.hamcrest.CoreMatchers.equalTo
import grails.test.GrailsUnitTestCase

/**
 * Unit tests for PurchaseOrderNumber domain class.
 */
class PurchaseOrderNumberTests extends GrailsUnitTestCase {
    protected void setUp() {
        super.setUp()
        mockDomain(PurchaseOrder)
        mockDomain(PurchaseOrderNumber)
    }

    protected void tearDown() {
        super.tearDown()
    }

    void testGetDescriptionForNewPurchaseOrder() {
        createTenPurchaseOrderNumbers()
        def pon = PurchaseOrderNumber.get(1)

        assertThat pon.description, equalTo("P1000 - new")
    }

    void testGetDescriptionForExistingPurchaseOrder() {
        def pon = new PurchaseOrderNumber(value:"P1234").save(failOnError:true)
        def supplier = new Supplier(name:"Supplier Name",supplierType:new SupplierType())
        def po = new PurchaseOrder(purchaseOrderNumber:pon, supplier:supplier)
        pon.purchaseOrder = po
        pon.save(failOnError:true)
        po.save(failOnError:true)

        assertThat pon.description, equalTo("P1234 for Supplier Name")
    }

    private createTenPurchaseOrderNumbers() {
        for (int i = 1000; i < 1010; i++) {
            new PurchaseOrderNumber(value: "P${i}").save(failOnError: true)
        }
    }

}
