<html>
    <head>
        <meta name="layout" content="main" />
        <title>Create Picture</title>
        <nav:resources override="true"/>
        <g:render template="/shared/pictureHead" />
    </head>
    <body>
        <div class="nav">
            <h1>Create Picture</h1>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${picture}">
                <div class="errors">
                    <g:renderErrors bean="${picture}" as="list" />
                </div>
            </g:hasErrors>
            <g:uploadForm action="save" onsubmit="return Lightbox.loading();">
                <g:hiddenField name="inventoryItem.id" value="${picture.inventoryItem.id}" />
                <div class="dialog">
                    <table>
                        <tbody>
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="inventoryItem.id">Inventory Item:</label>
                                </td>
                                <td valign="top" class="value">
                                    ${picture.inventoryItem}
                                </td>
                            </tr> 
                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="file">File:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean: picture, field: 'file', 'errors')}">
                                    <input type="file" id="file" name="file" size="40"/>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><input class="save" type="submit" value="Create" /></span>
                </div>
            </g:uploadForm>
        </div>
    </body>
</html>
