<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Task Search Calendar</title>
        <filterpane:includes />
        <nav:resources override="true"/>
        <resource:calendarMonthView  skin="calendarmonthviewCustom"/>
        <export:resource />
        <resource:dateChooser />
        <g:javascript src="taskQuickSearchPane.js" />
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>

        <div class="body">
            <g:render template="/shared/messages" />

            <filterpane:currentCriteria domainBean="Task"
                                    action="searchCalendar"
                                    dateFormat="EEE, dd-MMM-yyyy"
                                    removeImgDir="images" 
                                    removeImgFile="bullet_delete.png"
                                    title="Advanced Search"/>


            <div class="paginateButtons">
                <span class="searchButtons">
                    <a href='' onclick="showElement('searchPane'); return false;">Quick</a>
                </span>
                Results: ${taskInstanceList.size()} / ${taskInstanceTotal}
                <span class="searchButtons">
                    <filterpane:filterButton text="Advanced" appliedText="Advanced" />
                </span>
            </div>

            <jsUtil:toggleControl toggleId="options"
                                                    imageId="optionsImg"
                                                    closedImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_right.png')}"
                                                    openImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_down.png')}"
                                                    text="${g.message(code: 'default.options.text')}"
                                                    />

            <div id="options" style="display:none;">
                <g:form method="post" action="setSearchCalendarParamsMax" >
                    <g:hiddenField name="params" value="${filterParams}" />
                    <div class="dialog">
                        <table>
                            <tbody>

                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="max">Results per page:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <input type="text" maxlength="4" id="description" name="newMax" value="${params.max}"/>

                                        <span class="buttons">
                                            <g:actionSubmit action="setSearchCalendarParamsMax" class="go" value="Update" />
                                        </span>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                <export:formats  params="${filterParams}" formats="['csv', 'excel', 'pdf', 'rtf']"/>
                </g:form>
            </div>

            <br />

            <g:if test="${taskInstanceList.size() > 0}">
                    <div class="paginateButtons">
                        <g:link action="searchCalendar"
                                        params="[showMonth: previousYear.month, showYear: previousYear.year]">
                            &lt;&lt;
                        </g:link>
                        <g:link action="searchCalendar"
                                        params="[showMonth: previousMonth.month, showYear: previousMonth.year]">
                            &lt;
                        </g:link>
                        <span class="calendarMonthControlTitle">
                            <g:formatDate date="${showDate}" format="MMMM, yyyy"/>
                        </span>
                        <g:link action="searchCalendar"
                                        params="[showMonth: nextMonth.month, showYear: nextMonth.year]">
                            &gt;
                        </g:link>
                        <g:link action="searchCalendar"
                                        params="[showMonth: nextYear.month, showYear: nextYear.year]">
                            &gt;&gt;
                        </g:link>
                    </div>
                    <div>
                        <g:link action="searchCalendar"
                                        params="[showMonth: today.month, showYear: today.year]">
                            Today: <g:formatDate date="${today.date}" format="MMMM, yyyy"/>
                        </g:link>
                    </div>
                    <br />

                <richui:calendarMonthView items="${taskInstanceList}"
                                                                        createLink="true"
                                                                        constraintDateFields="['targetStartDate']"
                                                                        month="${showDate}"
                                                                        controller="taskDetailed"
                                                                        action="show"
                                                                        dayAction="create"/>
            </g:if>

            <filterpane:filterPane domainBean="Task"
                                    title="Advanced Search"
                                    action="searchCalendar"
                                    class="overlayPane"
                                    additionalProperties="id"
                                    excludeProperties="trash, targetCompletionDate"
                                    associatedProperties="taskPriority.name,
                                                                                leadPerson.lastName,
                                                                                leadPerson.firstName,
                                                                                taskGroup.name,
                                                                                associatedAssets.name,
                                                                                primaryAsset.name,
                                                                                taskStatus.name,
                                                                                taskType.name"
                                    filterPropertyValues="${['taskPriority.name':[values: associatedPropertyValues.taskPriorityList],
                                                                                'leadPerson.lastName':[values: associatedPropertyValues.lastNameList],
                                                                                'leadPerson.firstName':[values: associatedPropertyValues.firstNameList],
                                                                                'taskGroup.name':[values: associatedPropertyValues.taskGroupList],
                                                                                'associatedAssets.name':[values: associatedPropertyValues.assetList],
                                                                                'primaryAsset.name':[values: associatedPropertyValues.assetList],
                                                                                'taskStatus.name':[values: associatedPropertyValues.taskStatusList],
                                                                                'taskType.name':[values: associatedPropertyValues.taskTypeList],
                                                                                targetCompletionDate:[years: associatedPropertyValues.yearRange,precision:'day'],
                                                                                targetStartDate:[years: associatedPropertyValues.yearRange,precision:'day']
                                                                                ]}"/>

            <g:render template="quickSearchPane" />

        </div> <!-- end body div -->
    </body>
</html>
