

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Edit Asset</title>
        <nav:resources override="true"/>
    </head>
    <body>
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />
            <g:hasErrors bean="${assetInstance}">
            <div class="errors">
                <g:renderErrors bean="${assetInstance}" as="list" />
            </div>
            </g:hasErrors>
            <g:form method="post" >
                <input type="hidden" name="id" value="${assetInstance?.id}" />
                <input type="hidden" name="version" value="${assetInstance?.version}" />
                <div class="dialog">
                    <table>
                        <tbody>
                        
                            <tr class="prop">
                                <td valign="top" class="groupHeader">
                                    <label for="name">Asset</label>
                                </td>
                                <td valign="top" class="value">
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="groupName">
                                    <label for="name">Name:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'name','errors')}">
                                    <input type="text" class="description" maxlength="50" id="name" name="name" value="${fieldValue(bean:assetInstance,field:'name')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="groupName">
                                    <label for="description">Description:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'description','errors')}">
                                    <input type="text" class="description" maxlength="100" id="description" name="description" value="${fieldValue(bean:assetInstance,field:'description')}"/>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="groupName">
                                    <label for="comment">Comment:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'comment','errors')}">
                                    <textarea rows="5" cols="40" name="comment">${fieldValue(bean:assetInstance, field:'comment')}</textarea>
                                </td>
                            </tr>
                            
                            <tr class="prop">
                                <td valign="top" class="groupName">
                                    <label for="isActive">Is Active:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'isActive','errors')}">
                                    <g:checkBox name="isActive" value="${assetInstance?.isActive}" ></g:checkBox>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="groupName">
                                    <label for="section">Section:</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'section','errors')}">
                                    <g:select optionKey="id" from="${Section.list()}" name="section.id" value="${assetInstance?.section?.id}" ></g:select>
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="groupHeader">Extended Attributes</td>
                                <td  valign="top" style="text-align:left;" class="value">
                                </td>
                            </tr>
                            
                            <g:each var="a" in="${assetInstance.assetExtendedAttributes.sort { p1, p2 -> p1.extendedAttributeType.name.compareToIgnoreCase(p2.extendedAttributeType.name) }}">
                                <tr class="prop">
                                    <td valign="top" class="groupName">
                                        ${a.extendedAttributeType.name.encodeAsHTML()}:
                                    </td>
                                    
                                    <td  valign="top" style="text-align:left;" class="value">
                                        <g:link controller="assetExtendedAttributeDetailed" action="edit" id="${a.id}">
                                            ${a.value.encodeAsHTML()}
                                        </g:link>
                                    </td>
                                
                                </tr>
                            </g:each>
                            
                            <tr class="prop">
                                <td valign="top" class="name"></td>
                                <td  valign="top" style="text-align:left;" class="value">
                                    <g:link controller="assetExtendedAttributeDetailed" params="['asset.id':assetInstance?.id]" action="create">+Add Extended Attribute</g:link>
                                </td>
                            </tr>
                        
                            <tr class="prop">
                                <td valign="top" class="groupHeader">
                                    <label for="assetSubItems">Asset Tree</label>
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'assetSubItems','errors')}">
                                </td>
                            </tr> 
                        
                            <tr class="prop">
                                <td valign="top" class="groupName">
                                    Level 1 sub items:
                                </td>
                                <td valign="top" class="value ${hasErrors(bean:assetInstance,field:'assetSubItems','errors')}">
                                    <custom:checkBoxList name="assetSubItems"
                                                                    from="${possibleAssetSubItems}"
                                                                    value="${assetInstance?.assetSubItems.collect{it.id}}"
                                                                    optionKey="id"
                                                                    sortBy="name"
                                                                    linkController="assetSubItemDetailed"
                                                                    linkAction="show"/>

                                </td>
                            </tr> 

                            <tr class="prop">
                                <td valign="top" class="groupHeader">Life Plan</td>

                                <td  valign="top" style="text-align:left;" class="value">
                                </td>

                            </tr>
                            
                            <g:each var="t" in="${parentPMs}">
                                <tr class="prop">
                                    <td valign="top" class="name"></td>
                                    
                                    <td  valign="top" style="text-align:left;" class="value">
                                        <g:link controller="taskDetailed" action="show" id="${t.id}">
                                            Task #${t.id}
                                        </g:link>
                                        <g:if test="${t.approved}" >
                                            <img  src="${resource(dir:'images/skin',file:'cog.png')}" alt="Approved" title="Approved" />
                                        </g:if>
                                        <g:if test="${t.taskRecurringSchedule?.enabled}" >
                                            <img  src="${resource(dir:'images/skin',file:'arrow_refresh.png')}" alt="Recurrence Enabled" title="Recurrence Enabled" />
                                        </g:if>
                                        <g:if test="${t.taskStatus.id == 2}" >
                                            <img  src="${resource(dir:'images/skin',file:'arrow_right.png')}" alt="In Progress" title="In Progress" />
                                        </g:if>
                                        <g:if test="${t.attentionFlag}" >
                                            <img  src="${resource(dir:'images/skin',file:'flag_red.png')}" alt="Attention Flag" title="Attention Flag" />
                                        </g:if>
                                        <g:if test="${t.taskStatus.id == 3}" >
                                            <img  src="${resource(dir:'images/skin',file:'tick.png')}" alt="Complete" title="Complete" />
                                        </g:if>
                                        <br />
                                        ${fieldValue(bean:t, field:'description')}
                                        <br />
                                        <g:if test="${t.safetyRequirement}" >
                                            <img  src="${resource(dir:'images/skin',file:'lightning.png')}" alt="Safety Requirement" title="Safety Requirement" />
                                            Safety
                                        </g:if>
                                        <g:if test="${t.regulatoryRequirement}" >
                                            <img  src="${resource(dir:'images/skin',file:'script_lightning.png')}" alt="Regulatory Requirement" title="Regulatory Requirement" />
                                            Regulatory
                                        </g:if>
                                        <g:if test="${t.mandatoryRequirement}" >
                                            <img  src="${resource(dir:'images/skin',file:'script.png')}" alt="Mandatory Requirement" title="Mandatory Requirement" />
                                            Mandatory
                                        </g:if>
                                    </td>
                                    
                                </tr>
                            </g:each>
                            
                            <tr class="prop">
                                <td valign="top" class="name"></td>
                                <td  valign="top" style="text-align:left;" class="value">
                                    <g:link controller="taskDetailed" params="['primaryAsset.id':assetInstance?.id, 'taskType.id':6]" action="create">+Add ParentPM</g:link>
                                </td>
                            </tr>
                        
                        </tbody>
                    </table>
                </div>
                <div class="buttons">
                    <span class="button"><g:actionSubmit class="save" value="Update" /></span>
                    <span class="button"><g:actionSubmit class="cancel" value="Cancel" action="Show"/></span>
                    <span class="button"><g:actionSubmit class="delete" onclick="return confirm('Are you sure?');" value="Delete" /></span>
                </div>
            </g:form>
        </div>
    </body>
</html>
