import org.apache.commons.collections.list.LazyList
import org.apache.commons.collections.FactoryUtils

class TaskProcedure {

    Task linkedTask
    Person createdBy
    Person lastUpdatedBy
    Date dateCreated = new Date() // autoTimestamp
    Date lastUpdated = new Date() // autoTimestamp

    def getDescription() { linkedTask.description }
    def getAsset() { linkedTask.primaryAsset }

    List maintenanceActions = new ArrayList()
    List documentReferences = new ArrayList()

    static hasMany = [tasks: Task,
                                    maintenanceActions: MaintenanceAction,
                                    documentReferences: DocumentReference]

    def getMaintenanceActionLazyList() {
        return LazyList.decorate(maintenanceActions, FactoryUtils.instantiateFactory(MaintenanceAction.class))
    }

    def getDocumentReferenceLazyList() {
        return LazyList.decorate(documentReferences, FactoryUtils.instantiateFactory(DocumentReference.class))
    }

    static mappedBy = [tasks:"taskProcedure"]

    static mapping = {
        maintenanceActions cascade:"all-delete-orphan"
        documentReferences cascade:"all-delete-orphan"
    }

//     static belongsTo = []

    static constraints = {
    }

    String toString() {
        "${this.id}"
    }
}
