import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class AppConfigController extends BaseAppAdminController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        params.max = Math.min( params.max ? params.max.toInteger() : 10,  100)
        [ appConfigInstanceList: AppConfig.list( params ), appConfigInstanceTotal: AppConfig.count() ]
    }

    def show = {
        def appConfigInstance = AppConfig.get( params.id )

        if(!appConfigInstance) {
            flash.message = "AppConfig not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ appConfigInstance : appConfigInstance ] }
    }

    def delete = {
        def appConfigInstance = AppConfig.get( params.id )
        if(appConfigInstance) {
            try {
                appConfigInstance.delete(flush:true)
                flash.message = "AppConfig ${params.id} deleted"
                redirect(action:list)
            }
            catch(org.springframework.dao.DataIntegrityViolationException e) {
                flash.message = "AppConfig ${params.id} could not be deleted"
                redirect(action:show,id:params.id)
            }
        }
        else {
            flash.message = "AppConfig not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def appConfigInstance = AppConfig.get( params.id )

        if(!appConfigInstance) {
            flash.message = "AppConfig not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ appConfigInstance : appConfigInstance ]
        }
    }

    def update = {
        def appConfigInstance = AppConfig.get( params.id )
        if(appConfigInstance) {
            if(params.version) {
                def version = params.version.toLong()
                if(appConfigInstance.version > version) {
                    
                    appConfigInstance.errors.rejectValue("version", "default.optimistic.locking.failure")
                    render(view:'edit',model:[appConfigInstance:appConfigInstance])
                    return
                }
            }
            appConfigInstance.properties = params
            if(!appConfigInstance.hasErrors() && appConfigInstance.save(flush: true)) {
                flash.message = "AppConfig ${params.id} updated"
                redirect(action:show,id:appConfigInstance.id)
            }
            else {
                render(view:'edit',model:[appConfigInstance:appConfigInstance])
            }
        }
        else {
            flash.message = "AppConfig not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def create = {
        def appConfigInstance = new AppConfig()
        appConfigInstance.properties = params
        return ['appConfigInstance':appConfigInstance]
    }

    def save = {
        def appConfigInstance = new AppConfig(params)
        if(!appConfigInstance.hasErrors() && appConfigInstance.save(flush: true)) {
            flash.message = "AppConfig ${appConfigInstance.id} created"
            redirect(action:show,id:appConfigInstance.id)
        }
        else {
            render(view:'create',model:[appConfigInstance:appConfigInstance])
        }
    }
}
