class MaintenanceAction {

    TaskProcedure taskProcedure
    MaintenancePolicy maintenancePolicy
    Section section
    Asset asset
    AssetSubItem assetSubItem

    String description
    String pageRef = ""
    Integer procedureStepNumber

    Boolean toBeDeleted
    Boolean isNew
    static transients = [ 'toBeDeleted', 'isNew' ]

//     static hasMany = []

    static belongsTo = [TaskProcedure]

    static constraints = {
        section(nullable:true)
        asset(nullable:true)
        assetSubItem(nullable:true)
        maintenancePolicy(nullable:true)
        procedureStepNumber(nullable:true)
        description(blank:false,maxSize:100)
        pageRef(maxSize:100)
    }

    String toString() {
        "${this.description}"
    }
}

