class InventoryItemPurchase {

    PurchaseOrder purchaseOrder
    Person enteredBy
    Person lastUpdatedBy
    InventoryItem inventoryItem
    CostCode costCode
    InventoryItemPurchaseType inventoryItemPurchaseType
    Supplier supplier
    TaskBudgetStatus taskBudgetStatus

    Date date = new Date()
    Date lastUpdated // autoTimestamp
    Date dateCreated // autoTimestamp

    Integer quantity
    BigDecimal orderValueAmount
    Currency orderValueCurrency
    String invoiceNumber = ''
    String comment = ""

    Boolean receivedComplete = false
    Boolean invoicePaymentApproved = false

//     hasMany = []

    static belongsTo = [InventoryItem, PurchaseOrder]

    static constraints = {
        quantity(min:0)
        /// @todo: check constraints.
//        purchaseOrderNumber(blank:false, maxSize:50, validator: {val, obj ->
//            // For orders the purchaseOrderNumber must be unique for an inventoryItem.
//            if(obj.inventoryItemPurchaseType.id == 1L) {
//                def list = InventoryItemPurchase.withCriteria {
//                    eq('inventoryItem', obj.inventoryItem)
//                    eq('purchaseOrderNumber', obj.purchaseOrderNumber)
//                    eq('inventoryItemPurchaseType', obj.inventoryItemPurchaseType)
//                    if(obj.id)
//                        notEqual('id', obj.id)
//                }
//                if(list.size() > 0)
//                    return 'not.unique.for.inventory.item.order'
//            }
//            // Success.
//            return true
//        })
        invoiceNumber(maxSize:50)
        orderValueAmount(max: new BigDecimal(1000000000000))
        orderValueCurrency()
        comment(maxSize:255)
        lastUpdatedBy(nullable: true)
    }

    String toString() {
        "${this.quantity} x ${inventoryItem} - ${this.inventoryItemPurchaseType} "
    }

    static transients = [ 'purchaseOrderNumber' ]

    String getPurchaseOrderNumber() {
        return purchaseOrder?.purchaseOrderNumber?.value
    }
}
