

<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>InventoryItem Reorder</title>
        <nav:resources override="true"/>
        <g:render template="/shared/pictureHead" />
        <filterpane:includes />
        <export:resource />
    </head>
    <body onload="if(document.textSearchForm) {document.textSearchForm.searchText.focus();}">
        <div class="nav">
            <nav:renderSubItems group="nav"/>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />

            <div class="textSearchWrapper">
                <div class="textSearchInput">

                    <g:form method="post" id="textSearchForm" name="textSearchForm" >
                        <g:hiddenField name="newSearch" value="true" />

                            <span> <!--Prevent IE inheriting margin-->

                                <table>
                                    <tr>
                                        <td>
                                            <label for="selectedGroups">
                                                Group:
                                            </label>
                                        </td>
                                        <td>
                                            <custom:checkBoxList name="selectedGroups"
                                                                            from="${inventoryGroups}"
                                                                            value="${params.selectedGroups}"
                                                                            optionKey="id"
                                                                            sortBy="name"
                                                                            height="120px"/>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label for="selectedSupplier">
                                                Supplier:
                                            </label>
                                        </td>
                                        <td>
                                            <g:select optionKey="id"
                                                                from="${suppliers}"
                                                                name="selectedSupplier"
                                                                value="${params.selectedSupplier}"
                                                                noSelection="['null':'--None--']">
                                            </g:select>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                        </td>
                                        <td>
                                            <g:checkBox name="includeAlternateSuppliers" value="${params.includeAlternateSuppliers}" >
                                            </g:checkBox>
                                            <label for="includeAlternateSuppliers">
                                                Include alternate suppliers
                                            </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                        </td>
                                        <td>
                                            <g:checkBox name="includeReorderListingDisabled" value="${params.includeReorderListingDisabled}" >
                                            </g:checkBox>
                                            <label for="includeReorderListingDisabled">
                                                Include reorder listing disabled
                                            </label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                        </td>
                                        <td>
                                            <g:checkBox name="includeOnBackOrder" value="${params.includeOnBackOrder}" >
                                            </g:checkBox>
                                            <label for="includeOnBackOrder">
                                                Include items ordered in last 30 days.
                                            </label>
                                        </td>
                                    </tr>
                                </table>

                                <div class="paginateButtons">
                                    <span class="buttons">
                                        <g:actionSubmit class="search" value="Search" action="reorder" />
                                    </span>
                                    <div class="paginateButtons">
                                        Results: ${inventoryItemInstanceList.size()} / ${inventoryItemInstanceTotal}
                                    </div>
                                </div><!--paginateButtons-->
                            </span> <!--Prevent IE inheriting margin-->

                    </g:form>

                </div><!--textSearchInput-->

                <div class="textSearchRightFloat">
                    <div class="paginateButtons">
                        <span class="searchButtons">
                            <a href='' onclick="showElement('searchPane'); return false;">Quick</a>
                        </span>
                        <br />
                        <br />
                    </div>

                    <jsUtil:toggleControl toggleId="options"
                                                            imageId="optionsImg"
                                                            closedImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_right.png')}"
                                                            openImgUrl="${resource(dir:'images/skin',file:'bullet_arrow_down.png')}"
                                                            text="${g.message(code: 'default.options.text')}"
                                                            />
                </div><!--textSearchRightFloat-->
            </div><!--textSearchWrapper-->

            <div id="options" style="display:none; clear:both;">
                <g:form method="post" action="setReorderSearchParamsMax" >
                    <g:hiddenField name="params" value="${filterParams}" />
                    <div class="dialog">
                        <table>
                            <tbody>

                                <tr class="prop">
                                    <td valign="top" class="name">
                                        <label for="max">Results per page:</label>
                                    </td>
                                    <td valign="top" class="value">
                                        <input type="text" maxlength="4" id="description" name="newMax" value="${params.max}"/>

                                        <span class="buttons">
                                            <g:actionSubmit action="setReorderSearchParamsMax" class="go" value="Update" />
                                        </span>
                                    </td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                </g:form>
                <export:formats  params="${filterParams}" formats="['csv', 'excel', 'pdf', 'rtf']"/>
            </div>

            <br />

            <g:if test="${inventoryItemInstanceList.size() > 2}">
                <g:if test="${inventoryItemInstanceTotal > inventoryItemInstanceList.size()}">
                    <div class="paginateButtons">
                        <g:paginate action="reorder" total="${inventoryItemInstanceTotal}" params="${filterParams}" />
                    </div>
                </g:if>
            </g:if>

            <g:if test="${inventoryItemInstanceList.size() > 0}">
                <div class="list">
                    <table>
                        <thead>
                            <tr>

                                <th>Picture</th>
                                <th>Description</th>
                            
                                <g:sortableColumn property="inventoryGroup" title="Group" params="${filterParams}" />
                            
                                <g:sortableColumn property="unitsInStock" title="In Stock" params="${filterParams}" />

                                <th></th>
                            
                            </tr>
                        </thead>
                        <tbody>
                        <g:each in="${inventoryItemInstanceList}" status="i" var="inventoryItemInstance">
                            <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}" />

                                <td class='notClickable'>
                                    <g:if test="${inventoryItemInstance.picture}" >
                                        <wa:pictureLightboxAnchor picture="${inventoryItemInstance.picture}"
                                                                                            size="${Image.Small}"
                                                                                            lightboxSize="${Image.Large}"
                                                                                            target="_blank"
                                                                                            title="Show Original" />
                                    </g:if>
                                </td>
                            
                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemDetailed/show/${inventoryItemInstance.id}"' >
                                    <b>${fieldValue(bean:inventoryItemInstance, field:'name')}</b><br />
                                    ${fieldValue(bean:inventoryItemInstance, field:'description')}
                                    <br />
                                    <br />
                                    Comment:<br />
                                    ${inventoryItemInstance.comment?.encodeAsHTML()}
                                    <br />
                                    <br />
                                    Reorder Point: ${fieldValue(bean:inventoryItemInstance, field:'reorderPoint')}
                                    ${fieldValue(bean:inventoryItemInstance, field:'unitOfMeasure')}
                                    <br />
                                    P.Supplier: ${fieldValue(bean:inventoryItemInstance, field:'preferredSupplier')}
                                    <br />
                                    Spare For: ${inventoryItemInstance.spareFor.join(', ').encodeAsHTML()}
                                </td>
                            
                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemDetailed/show/${inventoryItemInstance.id}"' >
                                    ${fieldValue(bean:inventoryItemInstance, field:'inventoryGroup')}
                                </td>
                            
                                <td onclick='window.location = "${request.getContextPath()}/inventoryItemDetailed/show/${inventoryItemInstance.id}"' >
                                    ${fieldValue(bean:inventoryItemInstance, field:'unitsInStock')}
                                    ${fieldValue(bean:inventoryItemInstance, field:'unitOfMeasure')}
                                </td>

                                <td class="notClickable">
                                    <g:link action="show" id="${inventoryItemInstance.id}">
                                        <img  src="${resource(dir:'images/skin',file:'database_go.png')}" alt="Show" />
                                    </g:link>
                                </td>
                            
                            </tr>
                        </g:each>
                        </tbody>
                    </table>
                </div>
            </g:if>
            <div class="paginateButtons">
                <g:paginate action="reorder" total="${inventoryItemInstanceTotal}" params="${filterParams}" />
            </div>

        </div> <!-- end body div -->

        <!-- Start Search Pane -->
        <div class="overlayPane" id="searchPane" style="display:none;">
            <h2>Quick Search</h2>

            <g:form method="post" id="searchForm" name="searchForm" >
                <g:hiddenField name="newTextSearch" value="true" />

                <table>
                    <tbody>

                        <tr class="prop">
                            <td valign="top" class="name">
                                <label>Inventory:</label>
                            </td>
                            <td valign="top" class="value">
                                <g:link controller="inventoryItemDetailed"
                                                action="reorder"
                                                params="[quickSearch: 'all']">
                                                <g:message code="default.all.text" />
                                </g:link>
                                <br />
                                <g:link controller="inventoryItemDetailed"
                                                action="reorder"
                                                params="[quickSearch: 'inventoryBelowReorder']">
                                                <g:message code="inventoryItem.search.text.below.reorder" />
                                </g:link> - <g:message code="inventoryItem.search.text.below.reorder.description" />
                                <br />
                                <g:link controller="inventoryItemDetailed"
                                                action="reorder"
                                                params="[quickSearch: 'inventoryBelowReorderAll']">
                                                <g:message code="inventoryItem.search.text.below.reorder.all" />
                                </g:link> - <g:message code="inventoryItem.search.text.below.reorder.all.description" />
                                <br />
                                <g:link controller="inventoryItemDetailed"
                                                action="reorder"
                                                params="[quickSearch: 'recentlyUsed', daysBack: '14']">
                                                <g:message code="inventoryItem.search.text.recently.used" />
                                </g:link> - <g:message code="inventoryItem.search.text.recently.used.description" args="[14]"/>
                                <br />
                                <g:link controller="inventoryItemDetailed"
                                                action="reorder"
                                                params="[quickSearch: 'recentlyUsed', daysBack: '30']">
                                                <g:message code="inventoryItem.search.text.recently.used" />
                                </g:link> - <g:message code="inventoryItem.search.text.recently.used.description" args="[30]"/>
                            </td>
                        </tr>

                        <tr class="prop">
                            <td valign="top" class="name">
                                <label>Links:</label>
                            </td>
                            <td valign="top" class="value">
                                <g:link controller="inventoryItemPurchaseDetailed"
                                                action="search">
                                                Purchases
                                </g:link>
                            </td>
                        </tr>

                    </tbody>
                </table>

                <div class="buttons">
                    <span class="button">
                        <g:actionSubmit class="cancel" value="${g.message(code:'fp.tag.filterPane.button.cancel.text', default:'Cancel')}" onclick="return hideElement('searchPane');" />
                    </span>
                </div>
            </g:form>
        </div> <!-- end search pane -->

    </body>
</html>
