package gnumims.functional

import grails.plugin.geb.GebSpec
import gnumims.functional.pages.LoginPage
import geb.spock.GebReportingSpec
import geb.Browser
import geb.junit3.GebTest
import gnumims.functional.pages.HomePage
import spock.lang.Stepwise

@Stepwise
class LoginTests extends GebReportingSpec {
    String getBaseUrl() { "http://localhost:8080/gnumims" }
    File getReportDir() { new File("target/reports/geb") }

    def "We start at the login page"() {
        when:
        go getBaseUrl()

        then:
        $("h1").text() == "Welcome to gnuMims please log in"
    }

    def "When we click login we go to the home page"() {
        when:
        to LoginPage
        login.click(HomePage)

        then:
        at(HomePage)
    }

    def "When we click logout, we go back to the login page"() {
        when:
        to HomePage
        logout.click()

        then:
        at(LoginPage)
    }

    def "If we type in the wrong password"() {
        when:
        to LoginPage
        form.j_password = "bogus"
        login.click(LoginPage)

        then:
        $("div.login_message").text() == "[manager] wrong username/password."
    }

}
