dataSource {
    // Open separate connections to database for every request or pool connections.
    pooled = true
}
hibernate {
    cache.use_second_level_cache=true
    cache.use_query_cache=true
    cache.provider_class='net.sf.ehcache.hibernate.EhCacheProvider'
}

// dbCreate options.
// create-drop: Drop and re-create the database tables on restart. Deletes existing data.
// create:       Create the database if it doesn't exist, but don't modify it if it does. Deletes existing data.
// update:     Create the database if it doesn't exist, and modify it if it does exist. Keep data.
// If nothing specified then do nothing to database schema.

def appNameLowerCase = appName.toLowerCase()

// Environment specific settings.
// All production config is in external config.
environments {
    development {
        dataSource {
            /** HSQLDB - In memory */
            driverClassName = "org.hsqldb.jdbcDriver"
            username = "sa"
            password = ""
            dbCreate = "create-drop"
            url = "jdbc:hsqldb:mem:devDb"
            /** MySQL */
//             dialect = org.hibernate.dialect.MySQL5InnoDBDialect
//             driverClassName = "com.mysql.jdbc.Driver"
//             username = "${appNameLowerCase}admin"
//             password = "${appNameLowerCase}admin"
//             dbCreate = "create-drop"
//             url = "jdbc:mysql://host:3306/${appNameLowerCase}_dev?autoReconnect=true&sessionVariables=storage_engine=InnoDB"
        }
    }
    test {
        dataSource {
            /** HSQLDB - In memory */
            driverClassName = "org.hsqldb.jdbcDriver"
            username = "sa"
            password = ""
            dbCreate = "update"
            url = "jdbc:hsqldb:mem:devDb"
            /** MySQL */
//             dialect = org.hibernate.dialect.MySQL5InnoDBDialect
//             driverClassName = "com.mysql.jdbc.Driver"
//             username = "${appNameLowerCase}admin"
//             password = "${appNameLowerCase}admin"
//             dbCreate = "update"
//             url = "jdbc:mysql://host:3306/${appNameLowerCase}_test?autoReconnect=true&sessionVariables=storage_engine=InnoDB"
        }
    }
}
