<html>
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8"/>
        <meta name="layout" content="main" />
        <title>Work Load</title>
        <resource:dateChooser />
    </head>
    <body>
        <div class="nav">
            <h1>Work Load</h1>
        </div>
        <div class="body">
            <g:render template="/shared/messages" />

            <div class="paginateButtons">
                <span class="searchButtons">
                    <a href='' onclick="showElement('searchPane'); return false;">Search</a>
                </span>
            </div>

            <br />


            <g:if test="${workLoadGroups.size() > 0}">
                <h1>Assigned Groups</h1>
            </g:if>
            <g:else>
                <h1>No Assigned Groups Found</h1>
            </g:else>
                    <div class="list">
                        <table>
                            <thead>
                                <tr>
                                    <th>Assigned Group</th>
                                    <th>Duration</th>
                                </tr>
                            </thead>
                            <tbody>
                                <g:each in="${workLoadGroups}" status="i" var="workLoadGroup">
                                        <tr class="${(i % 2) == 0 ? 'clickableOdd' : 'clickableEven'}">

                                            <td class="notClickable">
                                                ${workLoadGroup.key}
                                            </td>

                                            <td class="notClickable">
                                                ${workLoadGroup.value.hours}:<g:formatNumber number="${workLoadGroup.value.minutes}" type="number" minIntegerDigits="2" />
                                            </td>

                                        </tr>
                                </g:each>
                                <tr class="total">
                                    <td>
                                        Total
                                    </td>
                                    <td>
                                        ${totalHours}:<g:formatNumber number="${totalMinutes}" type="number" minIntegerDigits="2" />
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>

            <br />

            <h1>Task Results: ${tasks.size()} / ${tasks.totalCount}</h1>

            <g:render template="list" model="[taskInstanceList:tasks]"/>

            <!-- Start Search Pane -->
            <div class="overlayPane" id="searchPane" style="display:none;">
                <h2>Search</h2>
                <g:form method="post" controller="taskDetailed">
                    <table>
                        <tbody>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label for="date">Date:</label>
                                </td>
                                <td valign="top" class="value">
                                    <richui:dateChooser name="startDate" format="dd-MM-yyyy" value="${startDate}" />
                                    to
                                    <richui:dateChooser name="endDate" format="dd-MM-yyyy" value="${endDate}" />
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label>Task Status:</label>
                                </td>
                                <td valign="top" class="value">
                                    <custom:checkBoxList name="taskStatusList"
                                                                            from="${TaskStatus.findAllByIsActive(true)}"
                                                                            value="${taskStatusList?.collect{it.id}}"
                                                                            optionKey="id"
                                                                            sortBy="name"
                                                                            linkController="taskStatusDetailed"
                                                                            linkAction="show"
                                                                            height="150px"/>
                                </td>
                            </tr>

                            <tr class="prop">
                                <td valign="top" class="name">
                                    <label>Task Groups:</label>
                                </td>
                                <td valign="top" class="value">
                                    <custom:checkBoxList name="taskGroups"
                                                                            from="${TaskGroup.findAllByIsActive(true)}"
                                                                            value="${taskGroups?.collect{it.id}}"
                                                                            optionKey="id"
                                                                            sortBy="name"
                                                                            linkController="taskGroupDetailed"
                                                                            linkAction="show"
                                                                            height="150px"/>
                                </td>
                            </tr>

                        </tbody>
                    </table>
                    <div class="buttons">
                        <span class="button">
                            <g:actionSubmit class="save" value="Update" action="workLoad" />
                            <g:actionSubmit class="cancel" value="${g.message(code:'fp.tag.filterPane.button.cancel.text', default:'Cancel')}" onclick="return hideElement('searchPane');" />
                        </span>
                    </div>
                </g:form>
            </div> <!-- end search pane -->

        </div> <!--body-->
    </body>
</html>
