/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.authentication;

import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.acegisecurity.userdetails.ldap.LdapUserDetails;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.core.AuthenticationSource;

public class AcegiAuthenticationSource
implements AuthenticationSource {
    private static final Log log = LogFactory.getLog((Class)(class$org$springframework$ldap$authentication$AcegiAuthenticationSource == null ? (class$org$springframework$ldap$authentication$AcegiAuthenticationSource = AcegiAuthenticationSource.class$("org.springframework.ldap.authentication.AcegiAuthenticationSource")) : class$org$springframework$ldap$authentication$AcegiAuthenticationSource));
    static /* synthetic */ Class class$org$springframework$ldap$authentication$AcegiAuthenticationSource;

    public String getPrincipal() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            Object principal = authentication.getPrincipal();
            if (principal instanceof LdapUserDetails) {
                LdapUserDetails details = (LdapUserDetails)principal;
                return details.getDn();
            }
            if (authentication instanceof AnonymousAuthenticationToken) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Anonymous Authentication, returning empty String as Principal");
                }
                return "";
            }
            throw new IllegalArgumentException("The principal property of the authentication object -needs to be a LdapUserDetails.");
        }
        log.warn((Object)"No Authentication object set in SecurityContext - returning empty String as Principal");
        return "";
    }

    public String getCredentials() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication != null) {
            return (String)authentication.getCredentials();
        }
        log.warn((Object)"No Authentication object set in SecurityContext - returning empty String as Credentials");
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

