/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jasig.cas.client.util.XmlUtils;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.Cas20ServiceTicketValidator;
import org.jasig.cas.client.validation.InvalidProxyChainTicketValidationException;
import org.jasig.cas.client.validation.TicketValidationException;

public final class Cas20ProxyTicketValidator
extends Cas20ServiceTicketValidator {
    private boolean acceptAnyProxy;
    private List allowedProxyChains = new ArrayList();

    public Cas20ProxyTicketValidator(String casServerUrlPrefix) {
        super(casServerUrlPrefix);
    }

    protected String getUrlSuffix() {
        return "proxyValidate";
    }

    protected void customParseResponse(String response, Assertion assertion) throws TicketValidationException {
        List proxies = XmlUtils.getTextForElements(response, "proxy");
        Object[] proxiedList = proxies.toArray(new String[proxies.size()]);
        if (proxies == null || proxies.isEmpty() || this.acceptAnyProxy) {
            return;
        }
        Iterator iter = this.allowedProxyChains.iterator();
        while (iter.hasNext()) {
            if (!Arrays.equals(proxiedList, (String[])iter.next())) continue;
            return;
        }
        throw new InvalidProxyChainTicketValidationException("Invalid proxy chain: " + proxies.toString());
    }

    public void setAcceptAnyProxy(boolean acceptAnyProxy) {
        this.acceptAnyProxy = acceptAnyProxy;
    }

    public void setAllowedProxyChains(List allowedProxyChains) {
        this.allowedProxyChains = allowedProxyChains;
    }
}

