/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.cas;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.proxy.ProxyGrantingTicketStorage;
import org.jasig.cas.client.util.CommonUtils;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.ui.AbstractProcessingFilter;
import org.springframework.security.ui.FilterChainOrder;

public class CasProcessingFilter
extends AbstractProcessingFilter {
    public static final String CAS_STATEFUL_IDENTIFIER = "_cas_stateful_";
    public static final String CAS_STATELESS_IDENTIFIER = "_cas_stateless_";
    private String proxyReceptorUrl;
    private ProxyGrantingTicketStorage proxyGrantingTicketStorage;

    public Authentication attemptAuthentication(HttpServletRequest request) throws AuthenticationException {
        String username = CAS_STATEFUL_IDENTIFIER;
        String password = request.getParameter("ticket");
        if (password == null) {
            password = "";
        }
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)CAS_STATEFUL_IDENTIFIER, (Object)password);
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    public String getDefaultFilterProcessesUrl() {
        return "/j_spring_cas_security_check";
    }

    public int getOrder() {
        return FilterChainOrder.CAS_PROCESSING_FILTER;
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String requestUri = request.getRequestURI();
        if (CommonUtils.isEmpty((String)this.proxyReceptorUrl) || !requestUri.endsWith(this.proxyReceptorUrl) || this.proxyGrantingTicketStorage == null) {
            return super.requiresAuthentication(request, response);
        }
        try {
            CommonUtils.readAndRespondToProxyReceptorRequest((HttpServletRequest)request, (HttpServletResponse)response, (ProxyGrantingTicketStorage)this.proxyGrantingTicketStorage);
            return false;
        }
        catch (IOException e) {
            return super.requiresAuthentication(request, response);
        }
    }

    public final void setProxyReceptorUrl(String proxyReceptorUrl) {
        this.proxyReceptorUrl = proxyReceptorUrl;
    }

    public final void setProxyGrantingTicketStorage(ProxyGrantingTicketStorage proxyGrantingTicketStorage) {
        this.proxyGrantingTicketStorage = proxyGrantingTicketStorage;
    }
}

