/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.ui.ntlm.ldap.authenticator;

import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.Authentication;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.ldap.SpringSecurityContextSource;
import org.springframework.security.ldap.SpringSecurityLdapTemplate;
import org.springframework.security.providers.ldap.authenticator.AbstractLdapAuthenticator;
import org.springframework.security.providers.ldap.authenticator.BindAuthenticator;
import org.springframework.security.ui.ntlm.NtlmUsernamePasswordAuthenticationToken;

public class NtlmAwareLdapAuthenticator
extends BindAuthenticator {
    private static final Log logger = LogFactory.getLog((Class)(class$org$springframework$security$ui$ntlm$ldap$authenticator$NtlmAwareLdapAuthenticator == null ? (class$org$springframework$security$ui$ntlm$ldap$authenticator$NtlmAwareLdapAuthenticator = NtlmAwareLdapAuthenticator.class$("org.springframework.security.ui.ntlm.ldap.authenticator.NtlmAwareLdapAuthenticator")) : class$org$springframework$security$ui$ntlm$ldap$authenticator$NtlmAwareLdapAuthenticator));
    static /* synthetic */ Class class$org$springframework$security$ui$ntlm$ldap$authenticator$NtlmAwareLdapAuthenticator;

    public NtlmAwareLdapAuthenticator(SpringSecurityContextSource contextSource) {
        super(contextSource);
    }

    protected DirContextOperations loadUser(String aUserDn, String aUserName) {
        SpringSecurityLdapTemplate template = new SpringSecurityLdapTemplate(this.getContextSource());
        try {
            DirContextOperations user = template.retrieveEntry(aUserDn, this.getUserAttributes());
            return user;
        }
        catch (NameNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Failed to load user " + aUserDn + ": " + e.getMessage()), (Throwable)e);
            }
            return null;
        }
    }

    public DirContextOperations authenticate(Authentication authentication) {
        if (!(authentication instanceof NtlmUsernamePasswordAuthenticationToken)) {
            return super.authenticate(authentication);
        }
        if (!authentication.isAuthenticated()) {
            throw new BadCredentialsException("Unauthenticated NTLM authentication token found");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"authenticate(NtlmUsernamePasswordAuthenticationToken) - start");
        }
        String userName = authentication.getName();
        DirContextOperations user = null;
        Iterator myDns = this.getUserDns(userName).iterator();
        while (myDns.hasNext() && user == null) {
            user = this.loadUser((String)myDns.next(), userName);
        }
        if (user == null && this.getUserSearch() != null) {
            DirContextOperations userFromSearch = this.getUserSearch().searchForUser(userName);
            user = this.loadUser(userFromSearch.getDn().toString(), userName);
        }
        if (user == null) {
            throw new BadCredentialsException(((AbstractLdapAuthenticator)this).messages.getMessage("BindAuthenticator.badCredentials", "Bad credentials"));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"authenticate(NtlmUsernamePasswordAuthenticationToken) - end");
        }
        return user;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

