/*
 * Copyright 2006-2007 Sxip Identity Corporation
 */

package org.openid4java.consumer;

import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;

import java.util.Date;

import org.apache.log4j.Logger;

/**
 * @author Marius Scurtescu, Johnny Bufu
 */
public class EhcacheNonceVerifier extends AbstractNonceVerifier
{
    private static Logger _log = Logger.getLogger(EhcacheNonceVerifier.class);
    private static final boolean DEBUG = _log.isDebugEnabled();

    private Cache _cache;

    public EhcacheNonceVerifier(int maxAge)
    {
        super(maxAge);
    }

    public void setCache(Cache cache)
    {
        if (cache.getTimeToLiveSeconds() != _maxAge)
        {
            throw new IllegalArgumentException("Max Age: " + _maxAge + ", same expected for cache, but found: " + cache.getTimeToLiveSeconds());
        }

        if (cache.getTimeToLiveSeconds() != cache.getTimeToIdleSeconds())
        {
            throw new IllegalArgumentException("Cache must have same timeToLive (" + cache.getTimeToLiveSeconds() + ") as timeToIdle (" + cache.getTimeToIdleSeconds() + ")");
        }

        _cache = cache;
    }

    protected int seen(Date now, String idpUrl, String nonce)
    {
        String pair = idpUrl + '#' + nonce;
        Element element = new Element(pair, pair);

        if (_cache.get(pair) != null)
        {
            _log.error("Possible replay attack! Already seen nonce: " + nonce);
            return SEEN;
        }

        _cache.put(element);

        if (DEBUG) _log.debug("Nonce verified: " + nonce);

        return OK;
    }
}
