import org.codehaus.groovy.grails.plugins.springsecurity.Secured

@Secured(['ROLE_AppAdmin'])
class PersonGroupTypeController extends BaseController {

    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    static allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        if(!params.max) params.max = 10
        [ personGroupTypeInstanceList: PersonGroupType.list( params ) ]
    }

    def show = {
        def personGroupTypeInstance = PersonGroupType.get( params.id )

        if(!personGroupTypeInstance) {
            flash.message = "PersonGroupType not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ personGroupTypeInstance : personGroupTypeInstance ] }
    }

    def delete = {
        def personGroupTypeInstance = PersonGroupType.get( params.id )
        if(personGroupTypeInstance) {
            personGroupTypeInstance.delete()
            flash.message = "PersonGroupType ${params.id} deleted"
            redirect(action:list)
        }
        else {
            flash.message = "PersonGroupType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def personGroupTypeInstance = PersonGroupType.get( params.id )

        if(!personGroupTypeInstance) {
            flash.message = "PersonGroupType not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ personGroupTypeInstance : personGroupTypeInstance ]
        }
    }

    def update = {
        def personGroupTypeInstance = PersonGroupType.get( params.id )
        if(personGroupTypeInstance) {
            personGroupTypeInstance.properties = params
            if(!personGroupTypeInstance.hasErrors() && personGroupTypeInstance.save()) {
                flash.message = "PersonGroupType ${params.id} updated"
                redirect(action:show,id:personGroupTypeInstance.id)
            }
            else {
                render(view:'edit',model:[personGroupTypeInstance:personGroupTypeInstance])
            }
        }
        else {
            flash.message = "PersonGroupType not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def personGroupTypeInstance = new PersonGroupType()
        personGroupTypeInstance.properties = params
        return ['personGroupTypeInstance':personGroupTypeInstance]
    }

    def save = {
        def personGroupTypeInstance = new PersonGroupType(params)
        if(!personGroupTypeInstance.hasErrors() && personGroupTypeInstance.save()) {
            flash.message = "PersonGroupType ${personGroupTypeInstance.id} created"
            redirect(action:show,id:personGroupTypeInstance.id)
        }
        else {
            render(view:'create',model:[personGroupTypeInstance:personGroupTypeInstance])
        }
    }
}
