/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.util;

import java.io.UnsupportedEncodingException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.springframework.security.SpringSecurityException;
import org.springframework.util.Assert;

public final class EncryptionUtils {
    private EncryptionUtils() {
    }

    public static byte[] stringToByteArray(String input) {
        Assert.hasLength((String)input, (String)"Input required");
        try {
            return input.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException fallbackToDefault) {
            return input.getBytes();
        }
    }

    public static String byteArrayToString(byte[] byteArray) {
        Assert.notNull((Object)byteArray, (String)"ByteArray required");
        Assert.isTrue((byteArray.length > 0 ? 1 : 0) != 0, (String)"ByteArray cannot be empty");
        try {
            return new String(byteArray, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            return new String(byteArray);
        }
    }

    private static byte[] cipher(String key, byte[] passedBytes, int cipherMode) throws EncryptionException {
        try {
            DESedeKeySpec keySpec = new DESedeKeySpec(EncryptionUtils.stringToByteArray(key));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("DESede");
            Cipher cipher = Cipher.getInstance("DESede/ECB/PKCS5Padding");
            SecretKey secretKey = keyFactory.generateSecret(keySpec);
            cipher.init(cipherMode, secretKey);
            return cipher.doFinal(passedBytes);
        }
        catch (Exception e) {
            throw new EncryptionException(e.getMessage(), e);
        }
    }

    public static String encrypt(String key, String inputString) throws EncryptionException {
        EncryptionUtils.isValidKey(key);
        byte[] cipherText = EncryptionUtils.cipher(key, EncryptionUtils.stringToByteArray(inputString), 1);
        return EncryptionUtils.byteArrayToString(Base64.encodeBase64((byte[])cipherText));
    }

    public static byte[] encrypt(String key, byte[] inputBytes) throws EncryptionException {
        EncryptionUtils.isValidKey(key);
        return Base64.encodeBase64((byte[])EncryptionUtils.cipher(key, inputBytes, 1));
    }

    public static String decrypt(String key, String inputString) throws EncryptionException {
        Assert.hasText((String)key, (String)"A key is required to attempt decryption");
        byte[] cipherText = EncryptionUtils.cipher(key, Base64.decodeBase64((byte[])EncryptionUtils.stringToByteArray(inputString)), 2);
        return EncryptionUtils.byteArrayToString(cipherText);
    }

    public static byte[] decrypt(String key, byte[] inputBytes) throws EncryptionException {
        Assert.hasText((String)key, (String)"A key is required to attempt decryption");
        return EncryptionUtils.cipher(key, Base64.decodeBase64((byte[])inputBytes), 2);
    }

    private static void isValidKey(String key) {
        Assert.hasText((String)key, (String)"A key to perform the encryption is required");
        Assert.isTrue((key.length() >= 24 ? 1 : 0) != 0, (String)"Key must be at least 24 characters long");
    }

    public static class EncryptionException
    extends SpringSecurityException {
        private static final long serialVersionUID = 1L;

        public EncryptionException(String message, Throwable t) {
            super(message, t);
        }

        public EncryptionException(String message) {
            super(message);
        }
    }
}

