/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.providers.openid;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationServiceException;
import org.springframework.security.BadCredentialsException;
import org.springframework.security.providers.AuthenticationProvider;
import org.springframework.security.providers.openid.AuthenticationCancelledException;
import org.springframework.security.providers.openid.OpenIDAuthenticationStatus;
import org.springframework.security.providers.openid.OpenIDAuthenticationToken;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.util.Assert;

public class OpenIDAuthenticationProvider
implements AuthenticationProvider,
InitializingBean {
    private UserDetailsService userDetailsService;
    static /* synthetic */ Class class$org$springframework$security$providers$openid$OpenIDAuthenticationToken;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.userDetailsService, (String)"The userDetailsService must be set");
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            return null;
        }
        if (authentication instanceof OpenIDAuthenticationToken) {
            OpenIDAuthenticationToken response = (OpenIDAuthenticationToken)authentication;
            OpenIDAuthenticationStatus status = response.getStatus();
            if (status == OpenIDAuthenticationStatus.SUCCESS) {
                UserDetails userDetails = this.userDetailsService.loadUserByUsername(response.getIdentityUrl());
                return new OpenIDAuthenticationToken(userDetails.getAuthorities(), response.getStatus(), response.getIdentityUrl());
            }
            if (status == OpenIDAuthenticationStatus.CANCELLED) {
                throw new AuthenticationCancelledException("Log in cancelled");
            }
            if (status == OpenIDAuthenticationStatus.ERROR) {
                throw new AuthenticationServiceException("Error message from server: " + response.getMessage());
            }
            if (status == OpenIDAuthenticationStatus.FAILURE) {
                throw new BadCredentialsException("Log in failed - identity could not be verified");
            }
            if (status == OpenIDAuthenticationStatus.SETUP_NEEDED) {
                throw new AuthenticationServiceException("The server responded setup was needed, which shouldn't happen");
            }
            throw new AuthenticationServiceException("Unrecognized return value " + status.toString());
        }
        return null;
    }

    public void setUserDetailsService(UserDetailsService userDetailsService) {
        this.userDetailsService = userDetailsService;
    }

    public boolean supports(Class authentication) {
        return (class$org$springframework$security$providers$openid$OpenIDAuthenticationToken == null ? (class$org$springframework$security$providers$openid$OpenIDAuthenticationToken = OpenIDAuthenticationProvider.class$("org.springframework.security.providers.openid.OpenIDAuthenticationToken")) : class$org$springframework$security$providers$openid$OpenIDAuthenticationToken).isAssignableFrom(authentication);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

