/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.xml;

import java.util.ArrayList;

public class TagHelper {
    public static StringBuffer makeStartTag(StringBuffer oBuffer, String sTag, String[] sAttrs, boolean bAddEOL) {
        oBuffer.append('<').append(sTag);
        if (sAttrs != null) {
            for (int i = 0; i < sAttrs.length; ++i) {
                oBuffer.append(' ');
                oBuffer.append(sAttrs[i]);
            }
        }
        oBuffer.append('>');
        if (bAddEOL) {
            oBuffer.append('\n');
        }
        return oBuffer;
    }

    public static StringBuffer makeStartTag(StringBuffer oBuffer, String sTag, boolean bAddEOL) {
        return TagHelper.makeStartTag(oBuffer, sTag, null, bAddEOL);
    }

    public static StringBuffer makeXRIDStartTag(StringBuffer oBuffer, String sTag, boolean bAddEOL) {
        return TagHelper.makeStartTag(oBuffer, sTag, new String[]{"xri://$xrd*($v*2.0)"}, bAddEOL);
    }

    public static StringBuffer makeXRIDStartTag(StringBuffer oBuffer, String sTag, String sXmlID, boolean bAddEOL, ArrayList xridExtensionAttributes, String xridExtensionElements) {
        String[] attrList = null;
        int extAttrListCount = 0;
        if (xridExtensionAttributes != null) {
            // empty if block
        }
        if (sXmlID == null || sXmlID.equals("")) {
            attrList = new String[1 + extAttrListCount];
            attrList[0] = "xri://$xrd*($v*2.0)";
        } else {
            attrList = new String[2 + extAttrListCount];
            attrList[0] = "xri://$xrd*($v*2.0)";
            attrList[1] = "id=\"" + sXmlID + "\"";
        }
        StringBuffer sbuf = new StringBuffer(250);
        sbuf.append(TagHelper.makeStartTag(oBuffer, sTag, attrList, bAddEOL).toString());
        sbuf.append("\n");
        sbuf.append(xridExtensionElements);
        return sbuf;
    }

    public static StringBuffer makeXRIDStartTag(StringBuffer oBuffer, String sTag, String sXmlID, boolean bAddEOL) {
        if (sXmlID == null || sXmlID.equals("")) {
            return TagHelper.makeXRIDStartTag(oBuffer, sTag, bAddEOL);
        }
        return TagHelper.makeStartTag(oBuffer, sTag, new String[]{"xri://$xrd*($v*2.0)", "id=\"" + sXmlID + "\""}, bAddEOL);
    }

    public static StringBuffer makeSAMLStartTag(StringBuffer oBuffer, String sTag, boolean bAddEOL) {
        return TagHelper.makeStartTag(oBuffer, sTag, new String[]{"xmlns=\"urn:oasis:names:tc:SAML:2.0:assertion\""}, bAddEOL);
    }

    public static StringBuffer makeSAMLStartTag(StringBuffer oBuffer, String sTag, String sXmlID, boolean bAddEOL) {
        if (sXmlID == null || sXmlID.equals("")) {
            return TagHelper.makeSAMLStartTag(oBuffer, sTag, bAddEOL);
        }
        return TagHelper.makeStartTag(oBuffer, sTag, new String[]{"xmlns=\"urn:oasis:names:tc:SAML:2.0:assertion\"", "ID=\"" + sXmlID + "\""}, bAddEOL);
    }

    public static StringBuffer makeEndTag(StringBuffer oBuffer, String sTag) {
        return oBuffer.append("</").append(sTag).append(">\n");
    }

    public static StringBuffer makeSimpleElement(StringBuffer oBuffer, String sTag, String[] sAttrs, String sValue) {
        TagHelper.makeStartTag(oBuffer, sTag, sAttrs, false).append(sValue);
        return TagHelper.makeEndTag(oBuffer, sTag);
    }

    public static StringBuffer makeSimpleElement(StringBuffer oBuffer, String sTag, String sValue) {
        return TagHelper.makeSimpleElement(oBuffer, sTag, null, sValue);
    }

    public static StringBuffer makeComplexElement(StringBuffer oBuffer, String sTag, String[] sAttrs, String sData, boolean bAddEOL) {
        TagHelper.makeStartTag(oBuffer, sTag, sAttrs, bAddEOL);
        oBuffer.append(sData);
        TagHelper.makeEndTag(oBuffer, sTag);
        return oBuffer;
    }
}

