/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.AllocationType;
import com.google.code.facebookapi.ApplicationProperty;
import com.google.code.facebookapi.ApplicationPropertySet;
import com.google.code.facebookapi.AssociationInfo;
import com.google.code.facebookapi.AssociationType;
import com.google.code.facebookapi.BatchQuery;
import com.google.code.facebookapi.BundleActionLink;
import com.google.code.facebookapi.BundleStoryTemplate;
import com.google.code.facebookapi.ErrorCode;
import com.google.code.facebookapi.FacebookException;
import com.google.code.facebookapi.FacebookJaxbRestClient;
import com.google.code.facebookapi.FacebookMethod;
import com.google.code.facebookapi.FacebookSignatureUtil;
import com.google.code.facebookapi.IFacebookMethod;
import com.google.code.facebookapi.IFacebookRestClient;
import com.google.code.facebookapi.IFeedImage;
import com.google.code.facebookapi.IPair;
import com.google.code.facebookapi.MarketListing;
import com.google.code.facebookapi.MarketListingStatus;
import com.google.code.facebookapi.MarketplaceListing;
import com.google.code.facebookapi.Metric;
import com.google.code.facebookapi.PageProfileField;
import com.google.code.facebookapi.Pair;
import com.google.code.facebookapi.Permission;
import com.google.code.facebookapi.PhotoTag;
import com.google.code.facebookapi.ProfileField;
import com.google.code.facebookapi.ProfileFieldItem;
import com.google.code.facebookapi.ProfileInfoField;
import com.google.code.facebookapi.PropertyType;
import com.google.code.facebookapi.TemplatizedAction;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ExtensibleClient<T>
implements IFacebookRestClient<T> {
    protected static Log log = LogFactory.getLog(ExtensibleClient.class);
    public static final int BATCH_LIMIT = 20;
    public static URL SERVER_URL = null;
    public static URL HTTPS_SERVER_URL = null;
    protected static JAXBContext JAXB_CONTEXT;
    protected URL _serverUrl;
    protected int _timeout;
    protected int _readTimeout;
    protected final String _apiKey;
    protected final String _secret;
    protected boolean _isDesktop;
    protected String cacheSessionKey;
    protected Long cacheUserId;
    protected Long cacheSessionExpires;
    protected String cacheSessionSecret;
    protected String rawResponse;
    protected boolean batchMode;
    protected List<BatchQuery> queries;
    protected String permissionsApiKey = null;
    protected static final String CRLF = "\r\n";
    protected static final String PREF = "--";
    protected static final int UPLOAD_BUFFER_SIZE = 1024;
    public static final String MARKETPLACE_STATUS_DEFAULT = "DEFAULT";
    public static final String MARKETPLACE_STATUS_NOT_SUCCESS = "NOT_SUCCESS";
    public static final String MARKETPLACE_STATUS_SUCCESS = "SUCCESS";
    @Deprecated
    protected Boolean cacheAppAdded;
    protected Boolean cacheAppUser;

    public static void initJaxbSupport() {
        if (JAXB_CONTEXT == null) {
            try {
                JAXB_CONTEXT = JAXBContext.newInstance((String)"com.google.code.facebookapi.schema");
            }
            catch (JAXBException ex) {
                log.error((Object)("MalformedURLException: " + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    protected ExtensibleClient(String apiKey, String secret) {
        this(SERVER_URL, apiKey, secret, null);
    }

    protected ExtensibleClient(String apiKey, String secret, int timeout) {
        this(SERVER_URL, apiKey, secret, null, timeout);
    }

    protected ExtensibleClient(String apiKey, String secret, String sessionKey) {
        this(SERVER_URL, apiKey, secret, sessionKey);
    }

    protected ExtensibleClient(String apiKey, String secret, String sessionKey, int connectionTimeout) {
        this(SERVER_URL, apiKey, secret, sessionKey, connectionTimeout);
    }

    protected ExtensibleClient(String serverAddr, String apiKey, String secret, String sessionKey) throws MalformedURLException {
        this(new URL(serverAddr), apiKey, secret, sessionKey);
    }

    protected ExtensibleClient(String serverAddr, String apiKey, String secret, String sessionKey, int connectionTimeout) throws MalformedURLException {
        this(new URL(serverAddr), apiKey, secret, sessionKey, connectionTimeout);
    }

    protected ExtensibleClient(URL serverUrl, String apiKey, String secret, String sessionKey, int timeout) {
        this(serverUrl, apiKey, secret, sessionKey);
        this._timeout = timeout;
    }

    protected ExtensibleClient(URL serverUrl, String apiKey, String secret, String sessionKey, int timeout, int readTimeout) {
        this(serverUrl, apiKey, secret, sessionKey);
        this._timeout = timeout;
        this._readTimeout = readTimeout;
    }

    protected ExtensibleClient(URL serverUrl, String apiKey, String secret, String sessionKey) {
        this.cacheSessionKey = sessionKey;
        this._apiKey = apiKey;
        this._secret = secret;
        this._serverUrl = null != serverUrl ? serverUrl : SERVER_URL;
        this._timeout = -1;
        this._readTimeout = -1;
        this.batchMode = false;
        this.queries = new ArrayList<BatchQuery>();
        if (this instanceof FacebookJaxbRestClient) {
            ExtensibleClient.initJaxbSupport();
        }
    }

    @Override
    public void beginPermissionsMode(String apiKey) {
        this.permissionsApiKey = apiKey;
    }

    @Override
    public void endPermissionsMode() {
        this.permissionsApiKey = null;
    }

    @Override
    public JAXBContext getJaxbContext() {
        return JAXB_CONTEXT;
    }

    @Override
    public void setJaxbContext(JAXBContext context) {
        JAXB_CONTEXT = context;
    }

    public abstract String getResponseFormat();

    public String getSessionSecret() {
        return this.cacheSessionSecret;
    }

    public void setSessionSecret(String key) {
        this.cacheSessionSecret = key;
    }

    private static CharSequence delimit(Iterable iterable) {
        if (iterable == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean empty = true;
        boolean notFirst = false;
        for (Object item : iterable) {
            if (notFirst) {
                buffer.append(",");
            } else {
                empty = false;
                notFirst = true;
            }
            buffer.append(item.toString());
        }
        if (empty) {
            return null;
        }
        return buffer;
    }

    @Override
    @Deprecated
    public Boolean getCacheAppAdded() {
        return this.cacheAppAdded;
    }

    @Override
    @Deprecated
    public void setCacheAppAdded(Boolean cacheAppAdded) {
        this.cacheAppAdded = cacheAppAdded;
    }

    @Override
    public Boolean getCacheAppUser() {
        return this.cacheAppUser;
    }

    @Override
    public void setCacheAppUser(Boolean cacheAppUser) {
        this.cacheAppUser = cacheAppUser;
    }

    @Override
    public String getCacheSessionSecret() {
        return this.cacheSessionSecret;
    }

    public void setCacheSessionSecret(String cacheSessionSecret) {
        this.cacheSessionSecret = cacheSessionSecret;
    }

    @Override
    public void setCacheSession(String cacheSessionKey, Long cacheUserId, Long cacheSessionExpires) {
        this.setCacheSessionKey(cacheSessionKey);
        this.setCacheUserId(cacheUserId);
        this.setCacheSessionExpires(cacheSessionExpires);
    }

    @Override
    public Long getCacheSessionExpires() {
        return this.cacheSessionExpires;
    }

    public void setCacheSessionExpires(Long cacheSessionExpires) {
        this.cacheSessionExpires = cacheSessionExpires;
    }

    @Override
    public String getCacheSessionKey() {
        return this.cacheSessionKey;
    }

    public void setCacheSessionKey(String cacheSessionKey) {
        this.cacheSessionKey = cacheSessionKey;
    }

    @Override
    public Long getCacheUserId() {
        return this.cacheUserId;
    }

    public void setCacheUserId(Long cacheUserId) {
        this.cacheUserId = cacheUserId;
    }

    @Override
    public T friends_areFriends(long userId1, long userId2) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_ARE_FRIENDS, ExtensibleClient.newPair("uids1", userId1), ExtensibleClient.newPair("uids2", userId2));
    }

    @Override
    public T friends_areFriends(Collection<Long> userIds1, Collection<Long> userIds2) throws FacebookException {
        if (userIds1 == null || userIds2 == null || userIds1.isEmpty() || userIds2.isEmpty()) {
            throw new IllegalArgumentException("Collections passed to friends_areFriends should not be null or empty");
        }
        if (userIds1.size() != userIds2.size()) {
            throw new IllegalArgumentException(String.format("Collections should be same size: got userIds1: %d elts; userIds2: %d elts", userIds1.size(), userIds2.size()));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_ARE_FRIENDS, ExtensibleClient.newPair("uids1", ExtensibleClient.delimit(userIds1)), ExtensibleClient.newPair("uids2", ExtensibleClient.delimit(userIds2)));
    }

    @Override
    public boolean fbml_refreshRefUrl(String url) throws FacebookException {
        try {
            return this.fbml_refreshRefUrl(new URL(url));
        }
        catch (MalformedURLException ex) {
            throw ExtensibleClient.runtimeException(ex);
        }
    }

    protected void handleFeedImages(List<Pair<String, CharSequence>> params, Collection<? extends IPair<? extends Object, URL>> images) {
        if (images != null && images.size() > 4) {
            throw new IllegalArgumentException("At most four images are allowed, got " + images.size());
        }
        if (null != images && !images.isEmpty()) {
            int image_count = 0;
            for (IPair<? extends Object, URL> iPair : images) {
                ++image_count;
                assert (null != iPair.getFirst()) : "Image URL must be provided";
                String name = "image_" + image_count;
                params.add(ExtensibleClient.newPair(name, iPair.getFirst()));
                if (null == iPair.getSecond()) continue;
                params.add(ExtensibleClient.newPair(name + "_link", iPair.getSecond()));
            }
        }
    }

    @Override
    public abstract String auth_getSession(String var1) throws FacebookException;

    @Override
    @Deprecated
    public boolean feed_publishTemplatizedAction(Long actorId, CharSequence titleTemplate) throws FacebookException {
        return this.feed_publishTemplatizedAction(actorId, titleTemplate, null, null, null, null, null, null);
    }

    @Override
    public boolean feed_publishTemplatizedAction(Long actorId, CharSequence titleTemplate, Map<String, CharSequence> titleData, CharSequence bodyTemplate, Map<String, CharSequence> bodyData, CharSequence bodyGeneral, Collection<Long> targetIds, Collection<? extends IPair<? extends Object, URL>> images) throws FacebookException {
        return this.feed_publishTemplatizedAction(titleTemplate, titleData, bodyTemplate, bodyData, bodyGeneral, targetIds, images, null);
    }

    @Override
    @Deprecated
    public boolean feed_publishTemplatizedAction(Integer actorId, CharSequence titleTemplate, Map<String, CharSequence> titleData, CharSequence bodyTemplate, Map<String, CharSequence> bodyData, CharSequence bodyGeneral, Collection<Long> targetIds, Collection<? extends IPair<? extends Object, URL>> images) throws FacebookException {
        return this.feed_publishTemplatizedAction((long)actorId, titleTemplate, titleData, bodyTemplate, bodyData, bodyGeneral, targetIds, images);
    }

    @Override
    public T groups_getMembers(Number groupId) throws FacebookException {
        assert (null != groupId);
        return this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET_MEMBERS, ExtensibleClient.newPair("gid", groupId));
    }

    private static String encode(CharSequence target) {
        if (target == null) {
            return "";
        }
        String result = ((Object)target).toString();
        try {
            result = URLEncoder.encode(result, "UTF8");
        }
        catch (UnsupportedEncodingException ex) {
            throw ExtensibleClient.runtimeException(ex);
        }
        return result;
    }

    @Override
    public T friends_getAppUsers() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET_APP_USERS, new Pair[0]);
    }

    @Override
    public T fql_query(CharSequence query) throws FacebookException {
        assert (null != query);
        return this.callMethod((IFacebookMethod)FacebookMethod.FQL_QUERY, ExtensibleClient.newPair("query", query));
    }

    private String generateSignature(List<String> params, boolean requiresSession) {
        String secret = this._secret;
        return FacebookSignatureUtil.generateSignature(params, secret);
    }

    @Override
    public T groups_get(Long userId, Collection<Long> groupIds) throws FacebookException {
        boolean hasGroups;
        boolean bl = hasGroups = null != groupIds && !groupIds.isEmpty();
        if (null != userId) {
            return hasGroups ? this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, ExtensibleClient.newPair("uid", userId), ExtensibleClient.newPair("gids", ExtensibleClient.delimit(groupIds))) : this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, ExtensibleClient.newPair("uid", userId));
        }
        return hasGroups ? this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, ExtensibleClient.newPair("gids", ExtensibleClient.delimit(groupIds))) : this.callMethod((IFacebookMethod)FacebookMethod.GROUPS_GET, new Pair[0]);
    }

    protected T callMethod(IFacebookMethod method, Pair<String, CharSequence> ... paramPairs) throws FacebookException {
        return this.callMethod(method, Arrays.asList(paramPairs), null, null);
    }

    protected T callMethod(IFacebookMethod method, Collection<Pair<String, CharSequence>> paramPairs) throws FacebookException {
        return this.callMethod(method, paramPairs, null, null);
    }

    protected T callMethod(IFacebookMethod method, Collection<Pair<String, CharSequence>> paramPairs, String fileName, InputStream fileStream) throws FacebookException {
        boolean includeSession;
        this.rawResponse = null;
        TreeMap<String, String> params = new TreeMap<String, String>();
        if (this.permissionsApiKey != null) {
            params.put("call_as_apikey", this.permissionsApiKey);
        }
        params.put("method", method.methodName());
        params.put("api_key", this._apiKey);
        params.put("v", "1.0");
        String format = this.getResponseFormat();
        if (null != format) {
            params.put("format", format);
        }
        params.put("call_id", Long.toString(System.currentTimeMillis()));
        boolean bl = includeSession = !method.requiresNoSession() && this.cacheSessionKey != null;
        if (includeSession) {
            params.put("session_key", this.cacheSessionKey);
        }
        for (Pair<String, CharSequence> p : paramPairs) {
            CharSequence oldVal = params.put((String)p.first, FacebookSignatureUtil.toString((CharSequence)p.second));
            if (oldVal == null) continue;
            log.warn((Object)String.format("For parameter %s, overwrote old value %s with new value %s.", p.first, oldVal, p.second));
        }
        assert (!params.containsKey("sig"));
        String signature = this.generateSignature(FacebookSignatureUtil.convert(params.entrySet()), includeSession);
        params.put("sig", signature);
        if (this.batchMode) {
            boolean addToBatch = true;
            if (method.methodName().equals(FacebookMethod.USERS_GET_LOGGED_IN_USER.methodName())) {
                Exception trace = new Exception();
                StackTraceElement[] traceElems = trace.getStackTrace();
                int index = 0;
                for (StackTraceElement elem : traceElems) {
                    if (elem.getMethodName().indexOf("_") != -1) {
                        StackTraceElement caller = traceElems[index + 1];
                        if (!caller.getClassName().equals(ExtensibleClient.class.getName()) || caller.getMethodName().startsWith("auth_")) break;
                        addToBatch = false;
                        break;
                    }
                    ++index;
                }
            }
            if (addToBatch) {
                this.queries.add(new BatchQuery(method, params));
            }
            return null;
        }
        boolean doHttps = this.isDesktop() && FacebookMethod.AUTH_GET_SESSION.equals(method);
        boolean doEncode = true;
        try {
            this.rawResponse = method.takesFile() ? this.postFileRequest(method, params, fileName, fileStream) : this.postRequest(method, params, doHttps);
            return this.parseCallResult(new ByteArrayInputStream(this.rawResponse.getBytes("UTF-8")), method);
        }
        catch (IOException ex) {
            throw ExtensibleClient.runtimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String postRequest(IFacebookMethod method, Map<String, String> params, boolean doHttps) throws IOException {
        String string;
        String paramString;
        URL serverUrl = doHttps ? HTTPS_SERVER_URL : this._serverUrl;
        CharSequence charSequence = paramString = null == params ? "" : ExtensibleClient.delimit(params.entrySet(), "&", "=", true);
        if (log.isDebugEnabled()) {
            log.debug((Object)(method.methodName() + " POST: " + serverUrl.toString() + "?" + paramString));
        }
        HttpURLConnection conn = null;
        OutputStream out = null;
        InputStream in = null;
        try {
            conn = (HttpURLConnection)serverUrl.openConnection();
            if (this._timeout != -1) {
                conn.setConnectTimeout(this._timeout);
            }
            if (this._readTimeout != -1) {
                conn.setReadTimeout(this._readTimeout);
            }
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.connect();
            out = conn.getOutputStream();
            out.write(paramString.toString().getBytes("UTF-8"));
            in = conn.getInputStream();
            string = this.getResponse(method, in);
        }
        catch (Throwable throwable) {
            ExtensibleClient.close(in);
            ExtensibleClient.close(out);
            ExtensibleClient.disconnect(conn);
            throw throwable;
        }
        ExtensibleClient.close(in);
        ExtensibleClient.close(out);
        ExtensibleClient.disconnect(conn);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String postFileRequest(IFacebookMethod method, Map<String, String> params, String fileName, InputStream fileStream) throws IOException {
        String string;
        HttpURLConnection con = null;
        OutputStream urlOut = null;
        InputStream in = null;
        try {
            String boundary = Long.toString(System.currentTimeMillis(), 16);
            con = (HttpURLConnection)this._serverUrl.openConnection();
            if (this._timeout != -1) {
                con.setConnectTimeout(this._timeout);
            }
            if (this._readTimeout != -1) {
                con.setReadTimeout(this._readTimeout);
            }
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
            con.setRequestProperty("MIME-version", "1.0");
            urlOut = con.getOutputStream();
            DataOutputStream out = new DataOutputStream(urlOut);
            for (Map.Entry<String, String> entry : params.entrySet()) {
                out.writeBytes(PREF + boundary + CRLF);
                out.writeBytes("Content-Type: text/plain;charset=utf-8\r\n");
                out.writeBytes("Content-disposition: form-data; name=\"" + entry.getKey() + "\"" + CRLF);
                out.writeBytes(CRLF);
                byte[] valueBytes = entry.getValue().toString().getBytes("UTF-8");
                out.write(valueBytes);
                out.writeBytes(CRLF);
            }
            out.writeBytes(PREF + boundary + CRLF);
            out.writeBytes("Content-Type: image\r\n");
            out.writeBytes("Content-disposition: form-data; filename=\"" + fileName + "\"" + CRLF);
            out.writeBytes(CRLF);
            byte[] buf = new byte[1024];
            int len = 0;
            while (len >= 0) {
                out.write(buf, 0, len);
                len = fileStream.read(buf);
            }
            out.writeBytes("\r\n--" + boundary + PREF + CRLF);
            out.flush();
            in = con.getInputStream();
            string = this.getResponse(method, in);
        }
        catch (Throwable throwable) {
            ExtensibleClient.close(urlOut);
            ExtensibleClient.close(in);
            ExtensibleClient.disconnect(con);
            throw throwable;
        }
        ExtensibleClient.close(urlOut);
        ExtensibleClient.close(in);
        ExtensibleClient.disconnect(con);
        return string;
    }

    private String getResponse(IFacebookMethod method, InputStream data) throws IOException {
        BufferedReader in = new BufferedReader(new InputStreamReader(data, "UTF-8"));
        StringBuilder buffer = new StringBuilder();
        char[] buf = new char[1000];
        int l = 0;
        while (l >= 0) {
            buffer.append(buf, 0, l);
            l = in.read(buf);
        }
        return buffer.toString();
    }

    protected abstract T parseCallResult(InputStream var1, IFacebookMethod var2) throws FacebookException, IOException;

    @Override
    public boolean fbml_refreshRefUrl(URL url) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FBML_REFRESH_REF_URL, ExtensibleClient.newPair("url", url)));
    }

    @Override
    public T notifications_get() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.NOTIFICATIONS_GET, new Pair[0]);
    }

    @Override
    public T users_getStandardInfo(Iterable<Long> userIds, Collection<ProfileField> fields) throws FacebookException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_STANDARD_INFO, ExtensibleClient.newPair("uids", ExtensibleClient.delimit(userIds)), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public T users_getStandardInfo(Iterable<Long> userIds, Set<CharSequence> fields) throws FacebookException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_STANDARD_INFO, ExtensibleClient.newPair("uids", ExtensibleClient.delimit(userIds)), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public T users_getInfo(Iterable<Long> userIds, Collection<ProfileField> fields) throws FacebookException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_INFO, ExtensibleClient.newPair("uids", ExtensibleClient.delimit(userIds)), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public T users_getInfo(Iterable<Long> userIds, Set<CharSequence> fields) throws FacebookException {
        assert (userIds != null);
        assert (fields != null);
        assert (!fields.isEmpty());
        return this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_INFO, ExtensibleClient.newPair("uids", ExtensibleClient.delimit(userIds)), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public long users_getLoggedInUser() throws FacebookException {
        if (this.cacheUserId == null || this.cacheUserId == -1L || this.batchMode) {
            this.cacheUserId = this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.USERS_GET_LOGGED_IN_USER, new Pair[0]));
        }
        return this.cacheUserId;
    }

    @Override
    @Deprecated
    public long auth_getUserId(String authToken) throws FacebookException {
        if (null == this.cacheSessionKey) {
            this.auth_getSession(authToken);
        }
        return this.users_getLoggedInUser();
    }

    @Override
    public boolean isDesktop() {
        return this._isDesktop;
    }

    @Override
    @Deprecated
    public boolean users_isAppAdded() throws FacebookException {
        if (this.cacheAppAdded == null) {
            this.cacheAppAdded = this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_ADDED, new Pair[0]));
        }
        return this.cacheAppAdded;
    }

    @Override
    public boolean users_isAppUser() throws FacebookException {
        if (this.cacheAppUser == null) {
            this.cacheAppUser = this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_USER, new Pair[0]));
        }
        return this.cacheAppUser;
    }

    @Override
    public boolean users_isAppUser(Long userId) throws FacebookException {
        if (userId != null) {
            return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_USER_NOSESSION, ExtensibleClient.newPair("uid", userId)));
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_USER, new Pair[0]));
    }

    @Override
    public boolean users_setStatus(String status) throws FacebookException {
        return this.users_setStatus(status, false, false);
    }

    @Override
    public boolean users_clearStatus() throws FacebookException {
        return this.users_setStatus(null, true);
    }

    @Override
    @Deprecated
    public URL notifications_send(Collection<Long> recipientIds, CharSequence notification, CharSequence email) throws FacebookException {
        this.notifications_send(recipientIds, notification);
        return null;
    }

    @Override
    public boolean fbml_refreshImgSrc(String imageUrl) throws FacebookException {
        try {
            return this.fbml_refreshImgSrc(new URL(imageUrl));
        }
        catch (MalformedURLException ex) {
            throw ExtensibleClient.runtimeException(ex);
        }
    }

    @Override
    public void setIsDesktop(boolean isDesktop) {
        this._isDesktop = isDesktop;
    }

    protected static CharSequence delimit(Collection<Map.Entry<String, String>> entries, String delimiter, String equals, boolean doEncode) {
        if (entries == null || entries.isEmpty()) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        boolean notFirst = false;
        for (Map.Entry<String, String> entry : entries) {
            if (notFirst) {
                buffer.append(delimiter);
            } else {
                notFirst = true;
            }
            CharSequence value = entry.getValue();
            buffer.append(entry.getKey()).append(equals).append(doEncode ? ExtensibleClient.encode(value) : value);
        }
        return buffer;
    }

    @Override
    public boolean fbml_refreshImgSrc(URL imageUrl) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FBML_REFRESH_IMG_SRC, ExtensibleClient.newPair("url", imageUrl)));
    }

    @Override
    public T friends_get() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET, new Pair[0]);
    }

    @Override
    public T friends_get(Long uid) throws FacebookException {
        if (uid != null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET_NOSESSION, ExtensibleClient.newPair("uid", uid));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET, new Pair[0]);
    }

    @Override
    public String auth_createToken() throws FacebookException {
        T d = this.callMethod((IFacebookMethod)FacebookMethod.AUTH_CREATE_TOKEN, new Pair[0]);
        return this.extractString(d);
    }

    @Override
    @Deprecated
    public Long marketplace_createListing(Boolean showOnProfile, MarketplaceListing attrs) throws FacebookException {
        T result = this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_CREATE_LISTING, ExtensibleClient.newPair("show_on_profile", showOnProfile != false ? "1" : "0"), ExtensibleClient.newPair("listing_id", "0"), ExtensibleClient.newPair("listing_attrs", attrs.jsonify()));
        return this.extractLong(result);
    }

    @Override
    @Deprecated
    public Long marketplace_editListing(Long listingId, Boolean showOnProfile, MarketplaceListing attrs) throws FacebookException {
        T result = this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_CREATE_LISTING, ExtensibleClient.newPair("show_on_profile", showOnProfile != false ? "1" : "0"), ExtensibleClient.newPair("listing_id", listingId), ExtensibleClient.newPair("listing_attrs", attrs.jsonify()));
        return this.extractLong(result);
    }

    @Override
    public boolean marketplace_removeListing(Long listingId) throws FacebookException {
        return this.marketplace_removeListing(listingId, MARKETPLACE_STATUS_DEFAULT);
    }

    @Override
    @Deprecated
    public boolean marketplace_removeListing(Long listingId, CharSequence status) throws FacebookException {
        assert (MARKETPLACE_STATUS_DEFAULT.equals(status) || MARKETPLACE_STATUS_SUCCESS.equals(status) || MARKETPLACE_STATUS_NOT_SUCCESS.equals(status)) : "Invalid status: " + status;
        T result = this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_REMOVE_LISTING, ExtensibleClient.newPair("listing_id", listingId), ExtensibleClient.newPair("status", status));
        return this.extractBoolean(result);
    }

    @Override
    @Deprecated
    public List<String> marketplace_getCategories() throws FacebookException {
        T temp = this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_GET_CATEGORIES, new Pair[0]);
        if (temp == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        if (temp instanceof Document) {
            Document d = (Document)temp;
            NodeList cats = d.getElementsByTagName("marketplace_category");
            for (int count = 0; count < cats.getLength(); ++count) {
                results.add(cats.item(count).getFirstChild().getTextContent());
            }
        } else {
            JSONObject j = (JSONObject)temp;
            Iterator it = j.keys();
            while (it.hasNext()) {
                try {
                    results.add(j.get((String)it.next()).toString());
                }
                catch (Exception ex) {
                    ExtensibleClient.runtimeException(ex);
                }
            }
        }
        return results;
    }

    @Override
    public T marketplace_getSubCategories(CharSequence category) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_GET_SUBCATEGORIES, ExtensibleClient.newPair("category", category));
    }

    @Override
    public T marketplace_getListings(Collection<Long> listingIds, Collection<Long> userIds) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(2);
        if (null != listingIds && !listingIds.isEmpty()) {
            params.add(ExtensibleClient.newPair("listing_ids", ExtensibleClient.delimit(listingIds)));
        }
        if (null != userIds && !userIds.isEmpty()) {
            params.add(ExtensibleClient.newPair("uids", ExtensibleClient.delimit(userIds)));
        }
        assert (!params.isEmpty()) : "Either listingIds or userIds should be provided";
        return this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_GET_LISTINGS, params);
    }

    @Override
    @Deprecated
    public T marketplace_search(CharSequence category, CharSequence subCategory, CharSequence query) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(3);
        boolean hasCategory = ExtensibleClient.addParamIfNotBlank("category", category, params);
        if (hasCategory) {
            ExtensibleClient.addParamIfNotBlank("subcategory", subCategory, params);
        }
        ExtensibleClient.addParamIfNotBlank("query", query, params);
        return this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_SEARCH, params);
    }

    @Override
    public T marketplace_getCategoriesObject() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_GET_CATEGORIES, new Pair[0]);
    }

    @Override
    public String getRawResponse() {
        return this.rawResponse;
    }

    @Override
    public Object getResponsePOJO() {
        if (this.rawResponse == null) {
            return null;
        }
        if (JAXB_CONTEXT == null) {
            return null;
        }
        if (this.getResponseFormat() != null && !"xml".equalsIgnoreCase(this.getResponseFormat())) {
            throw new RuntimeException("You can only generate a response POJO when using XML formatted API responses! JSON users go elsewhere!");
        }
        try {
            Unmarshaller unmarshaller = JAXB_CONTEXT.createUnmarshaller();
            return unmarshaller.unmarshal((InputStream)new ByteArrayInputStream(this.rawResponse.getBytes("UTF-8")));
        }
        catch (Exception ex) {
            throw ExtensibleClient.runtimeException(ex);
        }
    }

    @Override
    public boolean feed_PublishTemplatizedAction(TemplatizedAction action) throws FacebookException {
        return this.templatizedFeedHandler(action.getTitleTemplate(), action.getTitleParams(), action.getBodyTemplate(), action.getBodyParams(), action.getBodyGeneral(), action.getPictures(), action.getTargetIds(), action.getPageActorId());
    }

    @Override
    public boolean feed_publishTemplatizedAction(String titleTemplate, String titleData, String bodyTemplate, String bodyData, String bodyGeneral, Collection<? extends IPair<? extends Object, URL>> pictures, String targetIds) throws FacebookException {
        return this.templatizedFeedHandler(titleTemplate, titleData, bodyTemplate, bodyData, bodyGeneral, pictures, targetIds, null);
    }

    protected boolean templatizedFeedHandler(String titleTemplate, String titleData, String bodyTemplate, String bodyData, String bodyGeneral, Collection<? extends IPair<? extends Object, URL>> pictures, String targetIds, Long pageId) throws FacebookException {
        assert (pictures == null || pictures.size() <= 4);
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(15);
        ExtensibleClient.addParam("title_template", titleTemplate, params);
        ExtensibleClient.addParamIfNotBlank("title_data", titleData, params);
        boolean hasBody = ExtensibleClient.addParamIfNotBlank("body_template", bodyTemplate, params);
        if (hasBody) {
            ExtensibleClient.addParamIfNotBlank("body_data", bodyData, params);
        }
        ExtensibleClient.addParamIfNotBlank("body_general", bodyGeneral, params);
        if (pictures != null) {
            int count = 1;
            for (IPair<? extends Object, URL> iPair : pictures) {
                String url = iPair.getFirst().toString();
                if (url.startsWith("http://UID/")) {
                    url = url.substring("http://UID/".length());
                }
                ExtensibleClient.addParam("image_" + count, url, params);
                if (iPair.getSecond() != null) {
                    ExtensibleClient.addParam("image_" + count + "_link", ((Object)iPair.getSecond()).toString(), params);
                }
                ++count;
            }
        }
        ExtensibleClient.addParamIfNotBlank("target_ids", targetIds, params);
        ExtensibleClient.addParamIfNotBlank("page_actor_id", pageId, params);
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FEED_PUBLISH_TEMPLATIZED_ACTION, params));
    }

    @Override
    public boolean users_hasAppPermission(Permission perm) throws FacebookException {
        return this.users_hasAppPermission(perm, null);
    }

    @Override
    public boolean users_hasAppPermission(Permission perm, Long userId) throws FacebookException {
        if (userId != null) {
            return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_HAS_APP_PERMISSION_NOSESSION, ExtensibleClient.newPair("ext_perm", perm.getName()), ExtensibleClient.newPair("uid", userId)));
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_HAS_APP_PERMISSION, ExtensibleClient.newPair("ext_perm", perm.getName())));
    }

    @Override
    public Long marketplace_createListing(Long listingId, boolean showOnProfile, String attributes) throws FacebookException {
        T result = this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_CREATE_LISTING, ExtensibleClient.newPair("show_on_profile", showOnProfile ? "1" : "0"), ExtensibleClient.newPair("listing_id", "0"), ExtensibleClient.newPair("listing_attrs", attributes));
        return this.extractLong(result);
    }

    @Override
    public Long marketplace_createListing(Long listingId, boolean showOnProfile, MarketListing listing) throws FacebookException {
        return this.marketplace_createListing(listingId, showOnProfile, listing.getAttribs());
    }

    @Override
    public Long marketplace_createListing(boolean showOnProfile, MarketListing listing) throws FacebookException {
        return this.marketplace_createListing(null, showOnProfile, listing.getAttribs());
    }

    @Override
    public boolean marketplace_removeListing(Long listingId, MarketListingStatus status) throws FacebookException {
        return this.marketplace_removeListing(listingId, status.getName());
    }

    @Override
    public Long marketplace_editListing(Long listingId, Boolean showOnProfile, MarketListing attrs) throws FacebookException {
        T result = this.callMethod((IFacebookMethod)FacebookMethod.MARKETPLACE_CREATE_LISTING, ExtensibleClient.newPair("show_on_profile", showOnProfile != false ? "1" : "0"), ExtensibleClient.newPair("listing_id", listingId), ExtensibleClient.newPair("listing_attrs", attrs.getAttribs()));
        return this.extractLong(result);
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear) throws FacebookException {
        return this.users_setStatus(newStatus, clear, false);
    }

    @Override
    public T pages_getInfo(Collection<Long> pageIds, EnumSet<PageProfileField> fields) throws FacebookException {
        if (pageIds == null || pageIds.isEmpty()) {
            throw new IllegalArgumentException("pageIds cannot be empty or null");
        }
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        FacebookMethod method = null == this.cacheSessionKey ? FacebookMethod.PAGES_GET_INFO_NOSESSION : FacebookMethod.PAGES_GET_INFO;
        return this.callMethod((IFacebookMethod)method, ExtensibleClient.newPair("page_ids", ExtensibleClient.delimit(pageIds)), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public T pages_getInfo(Collection<Long> pageIds, Set<CharSequence> fields) throws FacebookException {
        if (pageIds == null || pageIds.isEmpty()) {
            throw new IllegalArgumentException("pageIds cannot be empty or null");
        }
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        FacebookMethod method = null == this.cacheSessionKey ? FacebookMethod.PAGES_GET_INFO_NOSESSION : FacebookMethod.PAGES_GET_INFO;
        return this.callMethod((IFacebookMethod)method, ExtensibleClient.newPair("page_ids", ExtensibleClient.delimit(pageIds)), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public T pages_getInfo(Long userId, EnumSet<PageProfileField> fields) throws FacebookException {
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        if (userId == null) {
            userId = this.cacheUserId;
        }
        if (userId == null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, ExtensibleClient.newPair("uid", userId), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public T pages_getInfo(Long userId, Set<CharSequence> fields) throws FacebookException {
        if (fields == null || fields.isEmpty()) {
            throw new IllegalArgumentException("fields cannot be empty or null");
        }
        if (userId == null) {
            userId = this.cacheUserId;
        }
        if (userId == null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PAGES_GET_INFO, ExtensibleClient.newPair("uid", userId), ExtensibleClient.newPair("fields", ExtensibleClient.delimit(fields)));
    }

    @Override
    public boolean pages_isAppAdded(Long pageId) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_APP_ADDED, ExtensibleClient.newPair("page_id", pageId)));
    }

    @Override
    public boolean pages_isFan(Long pageId, Long userId) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_FAN, ExtensibleClient.newPair("page_id", pageId), ExtensibleClient.newPair("uid", userId)));
    }

    @Override
    public boolean pages_isFan(Long pageId) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_FAN, ExtensibleClient.newPair("page_id", pageId)));
    }

    @Override
    public boolean pages_isAdmin(Long pageId) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PAGES_IS_ADMIN, ExtensibleClient.newPair("page_id", pageId)));
    }

    @Override
    public boolean fbml_setRefHandle(String handle, String fbmlMarkup) throws FacebookException {
        if (this._isDesktop) {
            throw new FacebookException(ErrorCode.GEN_PERMISSIONS_ERROR, "Desktop applications cannot use 'fbml_setReftHandle'");
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FBML_SET_REF_HANDLE, ExtensibleClient.newPair("handle", handle), ExtensibleClient.newPair("fbml", fbmlMarkup)));
    }

    @Override
    public void notifications_send(Collection<Long> recipientIds, CharSequence notification) throws FacebookException {
        this.notifications_send(recipientIds, ((Object)notification).toString(), false);
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear, boolean statusIncludesVerb) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (newStatus != null) {
            params.add(ExtensibleClient.newPair("status", newStatus));
        }
        if (clear) {
            params.add(ExtensibleClient.newPair("clear", "true"));
        }
        if (statusIncludesVerb) {
            params.add(ExtensibleClient.newPair("status_includes_verb", "true"));
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_SET_STATUS, params));
    }

    @Override
    public void notifications_send(CharSequence notification) throws FacebookException {
        Long currentUser = this.users_getLoggedInUser();
        ArrayList<Long> coll = new ArrayList<Long>();
        coll.add(currentUser);
        this.notifications_send(coll, notification);
    }

    @Override
    public T data_getCookies() throws FacebookException {
        return this.data_getCookies(this.users_getLoggedInUser(), null);
    }

    @Override
    public T data_getCookies(Long userId) throws FacebookException {
        return this.data_getCookies(userId, null);
    }

    @Override
    public T data_getCookies(String name) throws FacebookException {
        return this.data_getCookies(this.users_getLoggedInUser(), name);
    }

    @Override
    public T data_getCookies(Long userId, CharSequence name) throws FacebookException {
        if (name == null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_COOKIES, ExtensibleClient.newPair("uid", userId));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_COOKIES, ExtensibleClient.newPair("uid", userId), ExtensibleClient.newPair("name", name));
    }

    @Override
    public boolean data_setCookie(String name, String value) throws FacebookException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, null, null);
    }

    @Override
    public boolean data_setCookie(String name, String value, String path) throws FacebookException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, null, path);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value) throws FacebookException {
        return this.data_setCookie(userId, name, value, null, null);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value, CharSequence path) throws FacebookException {
        return this.data_setCookie(userId, name, value, null, path);
    }

    @Override
    public boolean data_setCookie(String name, String value, Long expires) throws FacebookException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, expires, null);
    }

    @Override
    public boolean data_setCookie(String name, String value, Long expires, String path) throws FacebookException {
        return this.data_setCookie(this.users_getLoggedInUser(), name, value, expires, path);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value, Long expires) throws FacebookException {
        return this.data_setCookie(userId, name, value, expires, null);
    }

    @Override
    public boolean data_setCookie(Long userId, CharSequence name, CharSequence value, Long expires, CharSequence path) throws FacebookException {
        if (name == null || "".equals(name)) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The cookie name cannot be null or empty!");
        }
        if (value == null) {
            value = "";
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(5);
        ExtensibleClient.addParam("uid", userId, params);
        ExtensibleClient.addParam("name", name, params);
        ExtensibleClient.addParam("value", value, params);
        ExtensibleClient.addParamIfNotBlankZero("expires", expires, params);
        ExtensibleClient.addParamIfNotBlank("path", path, params);
        T doc = this.callMethod((IFacebookMethod)FacebookMethod.DATA_SET_COOKIE, params);
        return this.extractBoolean(doc);
    }

    @Override
    public String data_getUserPreference(int prefId) throws FacebookException {
        return this.extractString(this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_USER_PREFERENCE, ExtensibleClient.newPair("pref_id", prefId)));
    }

    @Override
    public T data_getUserPreferences() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_USER_PREFERENCES, new Pair[0]);
    }

    @Override
    public void data_setUserPreference(int prefId, String value) throws FacebookException {
        if (value != null && value.length() > 128) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, String.format("Attempt to set a preference which hold a maximum of 128 characters to a value with %d characters. The Facebook API silently truncates this value to 128 characters which can lead to unpredictable results. If you want the truncation behaviour, please truncate the string in your Java code.", value.length()));
        }
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_SET_USER_PREFERENCE, ExtensibleClient.newPair("pref_id", prefId), ExtensibleClient.newPair("value", value));
    }

    @Override
    public void data_setUserPreferences(Map<Integer, String> values, boolean replace) throws FacebookException {
        JSONObject prefs = new JSONObject();
        for (Integer key : values.keySet()) {
            try {
                prefs.put(key.toString(), (Object)values.get(key));
            }
            catch (JSONException ex) {
                throw ExtensibleClient.runtimeException((Exception)((Object)ex));
            }
        }
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_SET_USER_PREFERENCES, ExtensibleClient.newPair("values", prefs.toString()), ExtensibleClient.newPairTF("replace", replace));
    }

    @Override
    public long data_createObject(String objectType, Map<String, String> properties) throws FacebookException {
        return this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.DATA_CREATE_OBJECT, ExtensibleClient.newPair("obj_type", objectType), ExtensibleClient.newPair("properties", ExtensibleClient.toJson(properties))));
    }

    @Override
    public void data_updateObject(long objectId, Map<String, String> properties, boolean replace) throws FacebookException {
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_UPDATE_OBJECT, ExtensibleClient.newPair("obj_id", String.valueOf(objectId)), ExtensibleClient.newPair("properties", ExtensibleClient.toJson(properties)), ExtensibleClient.newPairTF("replace", replace));
    }

    @Override
    public void data_deleteObject(long objectId) throws FacebookException {
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_DELETE_OBJECT, ExtensibleClient.newPair("obj_id", objectId));
    }

    @Override
    public void data_deleteObjects(Collection<Long> objectIds) throws FacebookException {
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_DELETE_OBJECTS, ExtensibleClient.newPair("obj_ids", ExtensibleClient.delimit(objectIds)));
    }

    @Override
    public T data_getObject(long objectId) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_OBJECT, ExtensibleClient.newPair("obj_id", objectId));
    }

    @Override
    public T data_getObjects(Collection<Long> objectIds) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_OBJECTS, ExtensibleClient.newPair("obj_ids", ExtensibleClient.delimit(objectIds)));
    }

    @Override
    public T data_getObjectProperty(long objectId, String propertyName) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_OBJECT_PROPERTY, ExtensibleClient.newPair("obj_id", objectId), ExtensibleClient.newPair("prop_name", propertyName));
    }

    @Override
    public void data_setObjectProperty(long objectId, String propertyName, String value) throws FacebookException {
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_SET_OBJECT_PROPERTY, ExtensibleClient.newPair("obj_id", objectId), ExtensibleClient.newPair("prop_name", propertyName), ExtensibleClient.newPair("value", value));
    }

    @Override
    public void data_createObjectType(String name) throws FacebookException {
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_CREATE_OBJECT_TYPE, ExtensibleClient.newPair("name", name));
    }

    @Override
    public void data_dropObjectType(String objectType) throws FacebookException {
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_DROP_OBJECT_TYPE, ExtensibleClient.newPair("obj_type", objectType));
    }

    @Override
    public void data_renameObjectType(String objectType, String newName) throws FacebookException {
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_RENAME_OBJECT_TYPE, ExtensibleClient.newPair("obj_type", objectType), ExtensibleClient.newPair("new_name", newName));
    }

    @Override
    public void data_defineObjectProperty(String objectType, String propertyName, PropertyType propertyType) throws FacebookException {
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_DEFINE_OBJECT_PROPERTY, ExtensibleClient.newPair("obj_type", objectType), ExtensibleClient.newPair("prop_name", propertyName), ExtensibleClient.newPair("prop_type", propertyType.getValue()));
    }

    @Override
    public void data_undefineObjectProperty(String objectType, String propertyName) throws FacebookException {
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_UNDEFINE_OBJECT_PROPERTY, ExtensibleClient.newPair("obj_type", objectType), ExtensibleClient.newPair("prop_name", propertyName));
    }

    @Override
    public void data_renameObjectProperty(String objectType, String propertyName, String newPropertyName) throws FacebookException {
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_RENAME_OBJECT_PROPERTY, ExtensibleClient.newPair("obj_type", objectType), ExtensibleClient.newPair("prop_name", propertyName), ExtensibleClient.newPair("new_name", newPropertyName));
    }

    @Override
    public T data_getObjectTypes() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_OBJECT_TYPES, new Pair[0]);
    }

    @Override
    public T data_getObjectType(String objectType) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_OBJECT_TYPE, ExtensibleClient.newPair("obj_type", objectType));
    }

    @Override
    public void data_defineAssociation(String associationName, AssociationType associationType, AssociationInfo associationInfo1, AssociationInfo associationInfo2, String inverseName) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(5);
        ExtensibleClient.addParam("name", associationName, params);
        ExtensibleClient.addParam("assoc_type", associationType.getValue(), params);
        JSONObject assocInfo1 = new JSONObject();
        try {
            assocInfo1.put("alias", (Object)associationInfo1.getAlias());
            assocInfo1.put("object_type", (Object)associationInfo1.getObjectType());
            assocInfo1.put("unique", associationInfo1.isUnique());
        }
        catch (JSONException ex) {
            throw ExtensibleClient.runtimeException((Exception)((Object)ex));
        }
        ExtensibleClient.addParam("assoc_info1", assocInfo1.toString(), params);
        JSONObject assocInfo2 = new JSONObject();
        try {
            assocInfo2.put("alias", (Object)associationInfo2.getAlias());
            assocInfo2.put("object_type", (Object)associationInfo2.getObjectType());
            assocInfo2.put("unique", associationInfo2.isUnique());
        }
        catch (JSONException ex) {
            throw ExtensibleClient.runtimeException((Exception)((Object)ex));
        }
        ExtensibleClient.addParam("assoc_info2", assocInfo2, params);
        ExtensibleClient.addParamIfNotBlank("inverse", inverseName, params);
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_DEFINE_ASSOCIATION, params);
    }

    @Override
    public void data_undefineAssociation(String name) throws FacebookException {
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_UNDEFINE_ASSOCIATION, ExtensibleClient.newPair("name", name));
    }

    @Override
    public void data_renameAssociation(String name, String newName, String newAlias1, String newAlias2) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(4);
        ExtensibleClient.addParam("name", name, params);
        ExtensibleClient.addParam("new_name", newName, params);
        ExtensibleClient.addParamIfNotBlank("new_alias1", newAlias1, params);
        ExtensibleClient.addParamIfNotBlank("new_alias2", newAlias2, params);
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_RENAME_ASSOCIATION, params);
    }

    @Override
    public T data_getAssociationDefinition(String name) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_ASSOCIATION_DEFINITION, ExtensibleClient.newPair("name", name));
    }

    @Override
    public T data_getAssociationDefinitions() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_ASSOCIATION_DEFINITIONS, new Pair[0]);
    }

    @Override
    public void data_setAssociation(String associationName, long object1Id, long object2Id, String data, Date associationTime) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(5);
        ExtensibleClient.addParam("name", associationName, params);
        ExtensibleClient.addParam("obj_id1", object1Id, params);
        ExtensibleClient.addParam("obj_id2", object2Id, params);
        ExtensibleClient.addParamIfNotBlank("data", data, params);
        ExtensibleClient.addParamSecondsIfNotBlank("assoc_time", associationTime, params);
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_SET_ASSOCIATION, params);
    }

    @Override
    public void data_removeAssociation(String associationName, long object1Id, long object2Id) throws FacebookException {
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_REMOVE_ASSOCIATION, ExtensibleClient.newPair("name", associationName), ExtensibleClient.newPair("obj_id1", object1Id), ExtensibleClient.newPair("obj_id2", object2Id));
    }

    @Override
    public void data_removeAssociatedObjects(String associationName, long objectId) throws FacebookException {
        this.callMethod((IFacebookMethod)FacebookMethod.DATA_REMOVE_ASSOCIATED_OBJECTS, ExtensibleClient.newPair("name", associationName), ExtensibleClient.newPair("obj_id", objectId));
    }

    @Override
    public long data_getAssociatedObjectCount(String associationName, long objectId) throws FacebookException {
        return this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.DATA_GET_ASSOCIATED_OBJECT_COUNT, ExtensibleClient.newPair("name", associationName), ExtensibleClient.newPair("obj_id", objectId)));
    }

    @Override
    public boolean admin_setAppProperties(Map<ApplicationProperty, String> properties) throws FacebookException {
        if (this._isDesktop) {
            throw new FacebookException(ErrorCode.GEN_PERMISSIONS_ERROR, "Desktop applications cannot use 'admin_setAppProperties'");
        }
        if (properties == null || properties.isEmpty()) {
            return true;
        }
        JSONObject encoding1 = new JSONObject();
        JSONArray encoding2 = new JSONArray();
        for (ApplicationProperty property : properties.keySet()) {
            JSONObject temp = new JSONObject();
            if (property.getType().equals("string")) {
                try {
                    encoding1.put(property.getName(), (Object)properties.get((Object)property));
                    temp.put(property.getName(), (Object)properties.get((Object)property));
                    encoding2.put((Object)temp);
                    continue;
                }
                catch (JSONException ex) {
                    throw ExtensibleClient.runtimeException((Exception)((Object)ex));
                }
            }
            String val = properties.get((Object)property);
            val = val == null || val.equals("") || val.equalsIgnoreCase("false") || val.equals("0") ? "0" : "1";
            try {
                encoding1.put(property.getName(), (Object)val);
                temp.put(property.getName(), (Object)val);
                encoding2.put((Object)temp);
            }
            catch (JSONException ex) {
                throw ExtensibleClient.runtimeException((Exception)((Object)ex));
            }
        }
        try {
            T d = this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_SET_APP_PROPERTIES, ExtensibleClient.newPair("properties", encoding1));
            return this.extractBoolean(d);
        }
        catch (FacebookException e) {
            T d = this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_SET_APP_PROPERTIES, ExtensibleClient.newPair("properties", encoding2));
            return this.extractBoolean(d);
        }
    }

    @Override
    @Deprecated
    public JSONObject admin_getAppProperties(Collection<ApplicationProperty> properties) throws FacebookException {
        String json = this.admin_getAppPropertiesAsString(properties);
        if (json == null) {
            return null;
        }
        try {
            if (json.matches("\\{.*\\}")) {
                return new JSONObject(json);
            }
            JSONArray temp = new JSONArray(json);
            JSONObject result = new JSONObject();
            for (int count = 0; count < temp.length(); ++count) {
                JSONObject obj = (JSONObject)temp.get(count);
                Iterator it = obj.keys();
                while (it.hasNext()) {
                    String next = (String)it.next();
                    result.put(next, obj.get(next));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new FacebookException(ErrorCode.GEN_SERVICE_ERROR, "Failed to parse server response:  " + json);
        }
    }

    @Override
    public Map<ApplicationProperty, String> admin_getAppPropertiesMap(Collection<ApplicationProperty> properties) throws FacebookException {
        String[] parts;
        LinkedHashMap<ApplicationProperty, String> result = new LinkedHashMap<ApplicationProperty, String>();
        String json = this.admin_getAppPropertiesAsString(properties);
        if (json == null) {
            return null;
        }
        json = json.matches("\\{.*\\}") ? json.substring(1, json.lastIndexOf("}")) : json.substring(1, json.lastIndexOf("]"));
        for (String part : parts = json.split("\\,")) {
            ExtensibleClient.parseFragment(part, result);
        }
        return result;
    }

    static Map<ApplicationProperty, String> parseProperties(String json) {
        String[] parts;
        TreeMap<ApplicationProperty, String> result = new TreeMap<ApplicationProperty, String>();
        if (json == null) {
            return null;
        }
        json = json.matches("\\{.*\\}") ? json.substring(1, json.lastIndexOf("}")) : json.substring(1, json.lastIndexOf("]"));
        for (String part : parts = json.split("\\,")) {
            ExtensibleClient.parseFragment(part, result);
        }
        return result;
    }

    private static void parseFragment(String fragment, Map<ApplicationProperty, String> result) {
        if (fragment.startsWith("{")) {
            fragment = fragment.substring(1, fragment.lastIndexOf("}"));
        }
        String keyString = fragment.substring(1);
        keyString = keyString.substring(0, keyString.indexOf(34));
        ApplicationProperty key = ApplicationProperty.getPropertyForString(keyString);
        String value = fragment.substring(fragment.indexOf(":") + 1).replaceAll("\\\\", "");
        if (key.getType().equals("string")) {
            result.put(key, value.substring(1, value.lastIndexOf(34)));
        } else if (value.equals("1")) {
            result.put(key, "true");
        } else {
            result.put(key, "false");
        }
    }

    @Override
    public boolean feed_publishTemplatizedAction(CharSequence titleTemplate) throws FacebookException {
        return this.feed_publishTemplatizedAction(titleTemplate, null);
    }

    @Override
    public boolean feed_publishTemplatizedAction(CharSequence titleTemplate, Long pageActorId) throws FacebookException {
        return this.feed_publishTemplatizedAction(titleTemplate, null, null, null, null, null, null, pageActorId);
    }

    @Override
    public boolean feed_publishTemplatizedAction(CharSequence titleTemplate, Map<String, CharSequence> titleData, CharSequence bodyTemplate, Map<String, CharSequence> bodyData, CharSequence bodyGeneral, Collection<Long> targetIds, Collection<? extends IPair<? extends Object, URL>> images, Long pageActorId) throws FacebookException {
        assert (null != titleTemplate && !"".equals(titleTemplate));
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(15);
        params.add(ExtensibleClient.newPair("title_template", titleTemplate));
        if (null != titleData && !titleData.isEmpty()) {
            JSONObject titleDataJson = new JSONObject();
            try {
                for (String key : titleData.keySet()) {
                    titleDataJson.put(key, (Object)titleData.get(key));
                }
            }
            catch (Exception ex) {
                throw ExtensibleClient.runtimeException(ex);
            }
            params.add(ExtensibleClient.newPair("title_data", titleDataJson));
        }
        if (null != bodyTemplate && !"".equals(bodyTemplate)) {
            params.add(ExtensibleClient.newPair("body_template", bodyTemplate));
            if (null != bodyData && !bodyData.isEmpty()) {
                JSONObject bodyDataJson = new JSONObject();
                try {
                    for (String key : bodyData.keySet()) {
                        bodyDataJson.put(key, (Object)bodyData.get(key));
                    }
                }
                catch (Exception ex) {
                    throw ExtensibleClient.runtimeException(ex);
                }
                params.add(ExtensibleClient.newPair("body_data", bodyDataJson));
            }
        }
        if (null != bodyTemplate && !"".equals(bodyTemplate)) {
            params.add(ExtensibleClient.newPair("body_template", bodyTemplate));
        }
        if (null != targetIds && !targetIds.isEmpty()) {
            params.add(ExtensibleClient.newPair("target_ids", ExtensibleClient.delimit(targetIds)));
        }
        if (bodyGeneral != null) {
            params.add(ExtensibleClient.newPair("body_general", bodyGeneral));
        }
        if (pageActorId != null) {
            params.add(ExtensibleClient.newPair("page_actor_id", pageActorId));
        }
        this.handleFeedImages(params, images);
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FEED_PUBLISH_TEMPLATIZED_ACTION, params));
    }

    @Override
    public T friends_getList(Long friendListId) throws FacebookException {
        if (null != friendListId && 0L <= friendListId) {
            throw new IllegalArgumentException("given invalid friendListId " + friendListId);
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET, ExtensibleClient.newPair("flid", friendListId));
    }

    @Override
    public T friends_getLists() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FRIENDS_GET_LISTS, new Pair[0]);
    }

    @Override
    public boolean admin_setAppProperties(ApplicationPropertySet properties) throws FacebookException {
        if (this._isDesktop) {
            throw new FacebookException(ErrorCode.GEN_PERMISSIONS_ERROR, "Desktop applications cannot use 'admin_setAppProperties'");
        }
        if (null == properties || properties.isEmpty()) {
            throw new IllegalArgumentException("expecting a non-empty set of application properties");
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_SET_APP_PROPERTIES, ExtensibleClient.newPair("properties", properties.toJsonString())));
    }

    @Override
    public ApplicationPropertySet admin_getAppPropertiesAsSet(EnumSet<ApplicationProperty> properties) throws FacebookException {
        String propJson = this.admin_getAppPropertiesAsString(properties);
        return new ApplicationPropertySet(propJson);
    }

    @Override
    public void beginBatch() {
        this.batchMode = true;
        this.queries = new ArrayList<BatchQuery>();
    }

    protected String encodeMethods(List<BatchQuery> queries) throws FacebookException {
        JSONArray result = new JSONArray();
        for (BatchQuery query : queries) {
            if (query.getMethod().takesFile()) {
                throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "File upload API calls cannot be batched:  " + query.getMethod().methodName());
            }
            result.put((Object)ExtensibleClient.delimit(query.getParams().entrySet(), "&", "=", true));
        }
        return result.toString();
    }

    @Override
    public T batch_run(String methods, boolean serial) throws FacebookException {
        if (!serial) {
            return this.callMethod((IFacebookMethod)FacebookMethod.BATCH_RUN, ExtensibleClient.newPair("method_feed", methods));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.BATCH_RUN, ExtensibleClient.newPair("method_feed", methods), ExtensibleClient.newPair("serial_only", "1"));
    }

    @Override
    public T application_getPublicInfo(Long applicationId, String applicationKey, String applicationCanvas) throws FacebookException {
        Pair<String, CharSequence> pair = null;
        if (applicationId != null && applicationId > 0L) {
            pair = ExtensibleClient.newPair("application_id", applicationId);
        } else if (applicationKey != null && !"".equals(applicationKey)) {
            pair = ExtensibleClient.newPair("application_api_key", applicationKey);
        } else if (applicationCanvas != null && !"".equals(applicationCanvas)) {
            pair = ExtensibleClient.newPair("application_canvas_name", applicationCanvas);
        } else {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "You must specify at least/most one of {applicationId, applicationKey, applicationCanvas}");
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.APPLICATION_GET_PUBLIC_INFO, pair);
    }

    @Override
    public T application_getPublicInfoById(Long applicationId) throws FacebookException {
        return this.application_getPublicInfo(applicationId, null, null);
    }

    @Override
    public T application_getPublicInfoByApiKey(String applicationKey) throws FacebookException {
        return this.application_getPublicInfo(null, applicationKey, null);
    }

    @Override
    public T application_getPublicInfoByCanvasName(String applicationCanvas) throws FacebookException {
        return this.application_getPublicInfo(null, null, applicationCanvas);
    }

    @Override
    public int admin_getAllocation(String allocationType) throws FacebookException {
        return this.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_ALLOCATION, ExtensibleClient.newPair("integration_point_name", allocationType)));
    }

    @Override
    public int admin_getAllocation(AllocationType allocationType) throws FacebookException {
        return this.admin_getAllocation(allocationType.getName());
    }

    @Override
    @Deprecated
    public int admin_getNotificationAllocation() throws FacebookException {
        return this.admin_getAllocation("notifications_per_day");
    }

    @Override
    @Deprecated
    public int admin_getRequestAllocation() throws FacebookException {
        return this.admin_getAllocation("requests_per_day");
    }

    @Override
    @Deprecated
    public T admin_getDailyMetrics(Set<Metric> metrics, Date start, Date end) throws FacebookException {
        return this.admin_getDailyMetrics(metrics, start.getTime(), end.getTime());
    }

    @Override
    @Deprecated
    public T admin_getDailyMetrics(Set<Metric> metrics, long start, long end) throws FacebookException {
        int size = 2 + (metrics != null ? metrics.size() : 0);
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(size);
        if (metrics != null) {
            metrics.remove((Object)Metric.ACTIVE_USERS);
            if (!metrics.isEmpty()) {
                JSONArray metricsJson = new JSONArray();
                for (Metric metric : metrics) {
                    metricsJson.put((Object)metric.getName());
                }
                params.add(ExtensibleClient.newPair("metrics", metricsJson));
            }
        }
        params.add(ExtensibleClient.newPair("start_date", start / 1000L));
        params.add(ExtensibleClient.newPair("end_date", end / 1000L));
        return this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_DAILY_METRICS, params);
    }

    @Override
    public T permissions_checkGrantedApiAccess(String apiKey) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PERM_CHECK_GRANTED_API_ACCESS, ExtensibleClient.newPair("permissions_apikey", apiKey));
    }

    @Override
    public T permissions_checkAvailableApiAccess(String apiKey) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PERM_CHECK_AVAILABLE_API_ACCESS, ExtensibleClient.newPair("permissions_apikey", apiKey));
    }

    @Override
    public boolean permissions_grantApiAccess(String apiKey, Set<FacebookMethod> methods) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (methods != null && !methods.isEmpty()) {
            JSONArray methodsJson = new JSONArray();
            for (FacebookMethod method : methods) {
                methodsJson.put((Object)method.methodName());
            }
            params.add(ExtensibleClient.newPair("method_arr", methodsJson));
        }
        params.add(ExtensibleClient.newPair("permissions_apikey", apiKey));
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PERM_GRANT_API_ACCESS, params));
    }

    @Override
    public boolean permissions_grantFullApiAccess(String apiKey) throws FacebookException {
        return this.permissions_grantApiAccess(apiKey, null);
    }

    @Override
    public boolean permissions_revokeApiAccess(String apiKey) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PERM_REVOKE_API_ACCESS, ExtensibleClient.newPair("permissions_apikey", apiKey)));
    }

    @Override
    public String auth_promoteSession() throws FacebookException {
        return this.extractString(this.callMethod((IFacebookMethod)FacebookMethod.AUTH_PROMOTE_SESSION, new Pair[0]));
    }

    @Override
    public boolean auth_revokeAuthorization() throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.AUTH_REVOKE_AUTHORIZATION, new Pair[0]));
    }

    @Override
    public boolean auth_expireSession() throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.AUTH_EXPIRE_SESSION, new Pair[0]));
    }

    @Override
    public Long marketplace_createListing(Long listingId, boolean showOnProfile, String attributes, Long userId) throws FacebookException {
        MarketListing test;
        if (listingId == null) {
            listingId = 0L;
        }
        if (!(test = new MarketListing(attributes)).verify()) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "The specified listing is invalid!");
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(4);
        params.add(ExtensibleClient.newPair("listing_id", listingId));
        if (showOnProfile) {
            params.add(ExtensibleClient.newPair("show_on_profile", "true"));
        }
        params.add(ExtensibleClient.newPair("listing_attrs", attributes));
        params.add(ExtensibleClient.newPair("uid", listingId));
        return this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.MARKET_CREATE_LISTING_NOSESSION, params));
    }

    @Override
    public Long marketplace_createListing(Long listingId, boolean showOnProfile, MarketListing listing, Long userId) throws FacebookException {
        return this.marketplace_createListing(listingId, showOnProfile, listing.getAttribs(), userId);
    }

    @Override
    public Long marketplace_createListing(boolean showOnProfile, MarketListing listing, Long userId) throws FacebookException {
        return this.marketplace_createListing((Long)0L, showOnProfile, listing.getAttribs(), userId);
    }

    @Override
    public boolean marketplace_removeListing(Long listingId, Long userId) throws FacebookException {
        return this.marketplace_removeListing(listingId, MarketListingStatus.DEFAULT, userId);
    }

    @Override
    public boolean marketplace_removeListing(Long listingId, MarketListingStatus status, Long userId) throws FacebookException {
        if (status == null) {
            status = MarketListingStatus.DEFAULT;
        }
        if (listingId == null) {
            return false;
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.MARKET_REMOVE_LISTING_NOSESSION, ExtensibleClient.newPair("listing_id", listingId), ExtensibleClient.newPair("status", status.getName()), ExtensibleClient.newPair("uid", userId)));
    }

    @Override
    @Deprecated
    public boolean users_isAppAdded(Long userId) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_IS_APP_ADDED_NOSESSION, ExtensibleClient.newPair("uid", userId)));
    }

    @Override
    public boolean users_setStatus(String status, Long userId) throws FacebookException {
        return this.users_setStatus(status, false, userId);
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear, Long userId) throws FacebookException {
        return this.users_setStatus(newStatus, clear, false, userId);
    }

    @Override
    public boolean users_setStatus(String newStatus, boolean clear, boolean statusIncludesVerb, Long userId) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (newStatus != null) {
            params.add(ExtensibleClient.newPair("status", newStatus));
        }
        if (clear) {
            params.add(ExtensibleClient.newPair("clear", "true"));
        }
        if (statusIncludesVerb) {
            params.add(ExtensibleClient.newPair("status_includes_verb", "true"));
        }
        params.add(ExtensibleClient.newPair("uid", userId));
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.USERS_SET_STATUS_NOSESSION, params));
    }

    @Override
    public T feed_getRegisteredTemplateBundleByID(Long id) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FEED_GET_TEMPLATE_BY_ID, ExtensibleClient.newPair("template_bundle_id", id));
    }

    @Override
    public T feed_getRegisteredTemplateBundles() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.FEED_GET_TEMPLATES, new Pair[0]);
    }

    @Override
    public Boolean feed_publishUserAction(Long bundleId) throws FacebookException {
        return this.feed_publishUserAction(bundleId, null, null, null);
    }

    @Override
    public Boolean feed_publishUserAction(Long bundleId, Map<String, String> templateData, List<Long> targetIds, String bodyGeneral) throws FacebookException {
        return this.feed_publishUserAction(bundleId, templateData, null, targetIds, bodyGeneral, 0);
    }

    @Override
    public Long feed_registerTemplateBundle(String template) throws FacebookException {
        ArrayList<String> temp = new ArrayList<String>();
        temp.add(template);
        return this.feed_registerTemplateBundle(temp);
    }

    @Override
    public Long feed_registerTemplateBundle(Collection<String> templates) throws FacebookException {
        return this.feed_registerTemplateBundle(templates, null, null);
    }

    @Override
    public Long feed_registerTemplateBundle(Collection<String> templates, Collection<BundleStoryTemplate> shortTemplates, BundleStoryTemplate longTemplate) throws FacebookException {
        return this.feed_registerTemplateBundle(templates, shortTemplates, longTemplate, null);
    }

    @Override
    public Long feed_registerTemplateBundle(Collection<String> templates, Collection<BundleStoryTemplate> shortTemplates, BundleStoryTemplate longTemplate, List<BundleActionLink> actionLinks) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        JSONArray templateArray = new JSONArray();
        for (String template : templates) {
            templateArray.put((Object)template);
        }
        params.add(ExtensibleClient.newPair("one_line_story_templates", templateArray));
        if (shortTemplates != null && !shortTemplates.isEmpty()) {
            JSONArray shortArray = new JSONArray();
            for (BundleStoryTemplate template : shortTemplates) {
                shortArray.put((Object)template.toJson());
            }
            params.add(ExtensibleClient.newPair("short_story_templates", shortArray));
        }
        if (longTemplate != null) {
            params.add(ExtensibleClient.newPair("full_story_template", longTemplate.toJsonString()));
        }
        if (actionLinks != null && !actionLinks.isEmpty()) {
            JSONArray actionLinkArray = new JSONArray();
            for (BundleActionLink actionLink : actionLinks) {
                actionLinkArray.put((Object)actionLink.toJson());
            }
            params.add(ExtensibleClient.newPair("action_links", actionLinkArray));
        }
        return this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.FEED_REGISTER_TEMPLATE, params));
    }

    @Override
    @Deprecated
    public Long feed_registerTemplateBundle(String template, String shortTemplate, String longTemplate) throws FacebookException {
        ArrayList<String> templates = new ArrayList<String>();
        templates.add(template);
        return this.feed_registerTemplateBundle(templates, null, null);
    }

    @Override
    public T profile_getFBML() throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, new Pair[0]);
    }

    @Override
    public T profile_getFBML(Long userId) throws FacebookException {
        if (userId != null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML_NOSESSION, ExtensibleClient.newPair("uid", userId));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, new Pair[0]);
    }

    @Override
    public T profile_getFBML(int type) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, ExtensibleClient.newPair("type", type));
    }

    @Override
    public T profile_getFBML(int type, Long userId) throws FacebookException {
        if (userId != null) {
            return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML_NOSESSION, ExtensibleClient.newPair("type", type), ExtensibleClient.newPair("uid", userId));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_FBML, ExtensibleClient.newPair("type", type));
    }

    @Override
    public T profile_getInfo(Long userId) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_INFO, ExtensibleClient.newPair("uid", userId));
    }

    @Override
    public T profile_getInfoOptions(String field) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_GET_INFO_OPTIONS, ExtensibleClient.newPair("field", field));
    }

    @Override
    public void profile_setInfo(Long userId, String title, boolean textOnly, List<ProfileInfoField> fields) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        JSONArray json = new JSONArray();
        params.add(ExtensibleClient.newPair("uid", userId));
        params.add(ExtensibleClient.newPair("title", title));
        if (textOnly) {
            params.add(ExtensibleClient.newPair("type", "1"));
        } else {
            params.add(ExtensibleClient.newPair("type", "5"));
        }
        for (ProfileInfoField field : fields) {
            try {
                JSONObject innerJSON = new JSONObject();
                JSONArray fieldItems = new JSONArray();
                innerJSON.put("field", (Object)field.getFieldName());
                for (ProfileFieldItem item : field.getItems()) {
                    JSONObject itemJSON = new JSONObject();
                    for (String key : item.getMap().keySet()) {
                        itemJSON.put(key, (Object)item.getMap().get(key));
                    }
                    fieldItems.put((Object)itemJSON);
                }
                innerJSON.put("items", (Object)fieldItems);
                json.put((Object)innerJSON);
            }
            catch (Exception ex) {
                throw ExtensibleClient.runtimeException(ex);
            }
        }
        params.add(ExtensibleClient.newPair("info_fields", json));
        this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_SET_INFO, params);
    }

    @Override
    public void profile_setInfoOptions(ProfileInfoField field) throws FacebookException {
        JSONArray json = new JSONArray();
        for (ProfileFieldItem item : field.getItems()) {
            JSONObject itemJSON = new JSONObject();
            for (String key : item.getMap().keySet()) {
                try {
                    itemJSON.put(key, (Object)item.getMap().get(key));
                }
                catch (Exception ex) {
                    throw ExtensibleClient.runtimeException(ex);
                }
            }
            json.put((Object)itemJSON);
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(2);
        ExtensibleClient.addParam("field", field.getFieldName(), params);
        ExtensibleClient.addParam("options", json.toString(), params);
        this.callMethod((IFacebookMethod)FacebookMethod.PROFILE_SET_INFO_OPTIONS, params);
    }

    @Override
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup) throws FacebookException {
        return this.profile_setFBML(null, ExtensibleClient.toString(profileFbmlMarkup), ExtensibleClient.toString(profileActionFbmlMarkup), null, null);
    }

    @Override
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup, Long profileId) throws FacebookException {
        return this.profile_setFBML(profileId, ExtensibleClient.toString(profileFbmlMarkup), ExtensibleClient.toString(profileActionFbmlMarkup), null, null);
    }

    @Override
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup, CharSequence mobileFbmlMarkup) throws FacebookException {
        return this.profile_setFBML(null, ExtensibleClient.toString(profileFbmlMarkup), ExtensibleClient.toString(profileActionFbmlMarkup), ExtensibleClient.toString(mobileFbmlMarkup), null);
    }

    @Override
    public boolean profile_setFBML(CharSequence profileFbmlMarkup, CharSequence profileActionFbmlMarkup, CharSequence mobileFbmlMarkup, Long profileId) throws FacebookException {
        return this.profile_setFBML(profileId, ExtensibleClient.toString(profileFbmlMarkup), ExtensibleClient.toString(profileActionFbmlMarkup), ExtensibleClient.toString(mobileFbmlMarkup), null);
    }

    @Override
    public boolean profile_setMobileFBML(CharSequence fbmlMarkup) throws FacebookException {
        return this.profile_setFBML(null, null, null, ExtensibleClient.toString(fbmlMarkup), null);
    }

    @Override
    public boolean profile_setMobileFBML(CharSequence fbmlMarkup, Long profileId) throws FacebookException {
        return this.profile_setFBML(profileId, null, null, ExtensibleClient.toString(fbmlMarkup), null);
    }

    @Override
    public boolean profile_setProfileActionFBML(CharSequence fbmlMarkup) throws FacebookException {
        return this.profile_setFBML(null, null, ExtensibleClient.toString(fbmlMarkup), null, null);
    }

    @Override
    public boolean profile_setProfileActionFBML(CharSequence fbmlMarkup, Long profileId) throws FacebookException {
        return this.profile_setFBML(profileId, null, ExtensibleClient.toString(fbmlMarkup), null, null);
    }

    @Override
    public boolean profile_setProfileFBML(CharSequence fbmlMarkup) throws FacebookException {
        return this.profile_setFBML(null, ExtensibleClient.toString(fbmlMarkup), null, null, null);
    }

    @Override
    public boolean profile_setProfileFBML(CharSequence fbmlMarkup, Long profileId) throws FacebookException {
        return this.profile_setFBML(profileId, ExtensibleClient.toString(fbmlMarkup), null, null, null);
    }

    @Override
    public boolean profile_setFBML(Long userId, String profileFbml, String actionFbml, String mobileFbml) throws FacebookException {
        return this.profile_setFBML(userId, profileFbml, actionFbml, mobileFbml, null);
    }

    @Override
    public boolean profile_setFBML(Long userId, String profileFbml, String actionFbml, String mobileFbml, String profileMain) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(5);
        ExtensibleClient.addParamIfNotBlank("uid", userId, params);
        ExtensibleClient.addParamIfNotBlank("profile", profileFbml, params);
        ExtensibleClient.addParamIfNotBlank("profile_action", actionFbml, params);
        ExtensibleClient.addParamIfNotBlank("mobile_fbml", mobileFbml, params);
        ExtensibleClient.addParamIfNotBlank("profile_main", profileMain, params);
        FacebookMethod method = this.isDesktop() || userId == null ? FacebookMethod.PROFILE_SET_FBML : FacebookMethod.PROFILE_SET_FBML_NOSESSION;
        return this.extractBoolean(this.callMethod((IFacebookMethod)method, params));
    }

    @Override
    public void setServerUrl(String newUrl) {
        String base = newUrl;
        if (base.startsWith("http")) {
            base = base.substring(base.indexOf("://") + 3);
        }
        try {
            String url = "http://" + base;
            this._serverUrl = new URL(url);
            this.setDefaultServerUrl(this._serverUrl);
        }
        catch (MalformedURLException ex) {
            throw ExtensibleClient.runtimeException(ex);
        }
    }

    @Override
    public URL getDefaultServerUrl() {
        return SERVER_URL;
    }

    @Override
    public void setDefaultServerUrl(URL newUrl) {
        SERVER_URL = newUrl;
    }

    @Override
    public Boolean liveMessage_send(Long recipient, String eventName, JSONObject message) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.LIVEMESSAGE_SEND, ExtensibleClient.newPair("recipient", recipient), ExtensibleClient.newPair("event_name", eventName), ExtensibleClient.newPair("message", message)));
    }

    @Override
    public T admin_getMetrics(Set<Metric> metrics, Date start, Date end, long period) throws FacebookException {
        return this.admin_getMetrics(metrics, start.getTime(), end.getTime(), period);
    }

    @Override
    public T admin_getMetrics(Set<Metric> metrics, long start, long end, long period) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        if (metrics != null && !metrics.isEmpty()) {
            JSONArray metricsJson = new JSONArray();
            for (Metric metric : metrics) {
                metricsJson.put((Object)metric.getName());
            }
            ExtensibleClient.addParam("metrics", metricsJson, params);
        }
        ExtensibleClient.addParam("start_time", start / 1000L, params);
        ExtensibleClient.addParam("end_time", end / 1000L, params);
        ExtensibleClient.addParam("period", period, params);
        return this.callMethod((IFacebookMethod)FacebookMethod.ADMIN_GET_METRICS, params);
    }

    @Override
    public boolean feed_deactivateTemplateBundleByID(Long bundleId) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FEED_DEACTIVATE_TEMPLATE_BUNDLE, ExtensibleClient.newPair("template_bundle_id", bundleId)));
    }

    @Override
    public void notifications_send(Collection<Long> recipientIds, String notification, boolean isAppToUser) throws FacebookException {
        if (null == notification || "".equals(notification)) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "You cannot send an empty notification!");
        }
        Pair<String, CharSequence> type = ExtensibleClient.newPair("type", isAppToUser ? "app_to_user" : "user_to_user");
        if (recipientIds != null && !recipientIds.isEmpty()) {
            this.callMethod((IFacebookMethod)FacebookMethod.NOTIFICATIONS_SEND, ExtensibleClient.newPair("to_ids", ExtensibleClient.delimit(recipientIds)), ExtensibleClient.newPair("notification", notification), type);
        } else {
            this.callMethod((IFacebookMethod)FacebookMethod.NOTIFICATIONS_SEND, ExtensibleClient.newPair("notification", notification), type);
        }
    }

    @Override
    public Boolean feed_publishUserAction(Long bundleId, Map<String, String> templateData, List<IFeedImage> images, List<Long> targetIds, String bodyGeneral, int storySize) throws FacebookException {
        if (images != null && images.size() > 4) {
            throw new IllegalArgumentException("Maximum of 4 images allowed per feed item.");
        }
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>();
        params.add(ExtensibleClient.newPair("template_bundle_id", bundleId));
        if (targetIds != null && !targetIds.isEmpty()) {
            params.add(ExtensibleClient.newPair("target_ids", ExtensibleClient.delimit(targetIds)));
        }
        if (bodyGeneral != null && !"".equals(bodyGeneral)) {
            params.add(ExtensibleClient.newPair("body_general", bodyGeneral));
        }
        if (storySize == 1 || storySize == 2 || storySize == 4) {
            params.add(ExtensibleClient.newPair("story_size", storySize));
        }
        JSONObject jsonTemplateData = new JSONObject();
        if (templateData != null && !templateData.isEmpty()) {
            for (String key : templateData.keySet()) {
                try {
                    jsonTemplateData.put(key, (Object)templateData.get(key));
                }
                catch (Exception exception) {
                    throw ExtensibleClient.runtimeException(exception);
                }
            }
        }
        if (images != null && !images.isEmpty()) {
            try {
                JSONArray jsonArray = new JSONArray();
                for (int i = 0; i < images.size(); ++i) {
                    IFeedImage image = images.get(i);
                    JSONObject jsonImage = new JSONObject();
                    jsonImage.put("src", (Object)image.getImageUrlString());
                    jsonImage.put("href", (Object)image.getLinkUrl().toExternalForm());
                    jsonArray.put(i, (Object)jsonImage);
                }
                jsonTemplateData.put("images", (Object)jsonArray);
            }
            catch (Exception exception) {
                throw ExtensibleClient.runtimeException(exception);
            }
        }
        if (jsonTemplateData.length() > 0) {
            params.add(ExtensibleClient.newPair("template_data", jsonTemplateData));
        }
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.FEED_PUBLISH_USER_ACTION, params));
    }

    protected static void disconnect(HttpURLConnection conn) {
        if (conn != null) {
            conn.disconnect();
        }
    }

    protected static void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException ex) {
                log.warn((Object)"Trouble closing connection", (Throwable)ex);
            }
        }
    }

    protected static RuntimeException runtimeException(Exception ex) {
        if (!(ex instanceof RuntimeException)) {
            return new RuntimeException(ex);
        }
        return (RuntimeException)ex;
    }

    protected static void printDom(Node n, String prefix, StringBuilder sb) {
        String outString = prefix;
        outString = n.getNodeType() == 3 ? outString + "'" + n.getTextContent().trim() + "'" : outString + n.getNodeName();
        sb.append(outString);
        sb.append("\n");
        NodeList children = n.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            ExtensibleClient.printDom(children.item(i), prefix + "  ", sb);
        }
    }

    protected static Pair<String, CharSequence> newPair(String name, Object value) {
        return new Pair<String, CharSequence>(name, String.valueOf(value));
    }

    @Deprecated
    protected static Pair<String, CharSequence> newPair(String name, boolean value) {
        return ExtensibleClient.newPair10(name, value);
    }

    protected static Pair<String, CharSequence> newPair10(String name, boolean value) {
        return ExtensibleClient.newPair(name, value ? "1" : "0");
    }

    protected static Pair<String, CharSequence> newPairTF(String name, boolean value) {
        return ExtensibleClient.newPair(name, value ? "true" : "false");
    }

    protected static Pair<String, CharSequence> newPair(String name, CharSequence value) {
        return new Pair<String, CharSequence>(name, value);
    }

    protected static Pair<String, CharSequence> newPair(String name, Long value) {
        return new Pair<String, CharSequence>(name, Long.toString(value));
    }

    protected static Pair<String, CharSequence> newPair(String name, Integer value) {
        return new Pair<String, CharSequence>(name, Integer.toString(value));
    }

    protected static boolean addParam(String name, Long value, Collection<Pair<String, CharSequence>> params) {
        params.add(ExtensibleClient.newPair(name, value));
        return true;
    }

    protected static boolean addParamIfNotBlank(String name, Long value, Collection<Pair<String, CharSequence>> params) {
        if (value != null) {
            return ExtensibleClient.addParam(name, value, params);
        }
        return false;
    }

    protected static boolean addParamSecondsIfNotBlank(String name, Date value, Collection<Pair<String, CharSequence>> params) {
        if (value != null) {
            return ExtensibleClient.addParam(name, value.getTime() / 1000L, params);
        }
        return false;
    }

    protected static boolean addParamIfNotBlankZero(String name, Long value, Collection<Pair<String, CharSequence>> params) {
        if (value != null && value != 0L) {
            return ExtensibleClient.addParam(name, value, params);
        }
        return false;
    }

    protected static boolean addParamDelimitIfNotBlankEmpty(String name, Iterable value, Collection<Pair<String, CharSequence>> params) {
        return ExtensibleClient.addParamIfNotBlank(name, ExtensibleClient.delimit(value), params);
    }

    protected static boolean addParam(String name, Object value, Collection<Pair<String, CharSequence>> params) {
        params.add(ExtensibleClient.newPair(name, value));
        return true;
    }

    protected static boolean addParam(String name, CharSequence value, Collection<Pair<String, CharSequence>> params) {
        params.add(ExtensibleClient.newPair(name, value));
        return true;
    }

    protected static boolean addParamIfNotBlank(String name, CharSequence value, Collection<Pair<String, CharSequence>> params) {
        if (value != null && !"".equals(value)) {
            params.add(ExtensibleClient.newPair(name, value));
            return true;
        }
        return false;
    }

    protected static String toString(CharSequence cs) {
        return cs == null ? null : ((Object)cs).toString();
    }

    protected static JSONObject toJson(Map<String, String> map) {
        return new JSONObject(map);
    }

    protected static JSONArray toJsonListOfStrings(Collection<String> list) {
        return new JSONArray(list);
    }

    protected static JSONArray toJsonListOfMaps(Collection<Map<String, String>> listOfMaps) {
        JSONArray out = new JSONArray();
        for (Map<String, String> map : listOfMaps) {
            out.put((Object)ExtensibleClient.toJson(map));
        }
        return out;
    }

    protected boolean extractBoolean(T result) {
        if (result == null) {
            return false;
        }
        return 1 == this.extractInt(result);
    }

    protected abstract int extractInt(T var1);

    protected abstract Long extractLong(T var1);

    protected abstract URL extractURL(T var1) throws IOException;

    protected abstract String extractString(T var1);

    @Override
    public T events_get(Long userId, Collection<Long> eventIds, Long startTime, Long endTime) throws FacebookException {
        return this.events_get(userId, eventIds, startTime, endTime, null);
    }

    @Override
    public T events_get(Long userId, Collection<Long> eventIds, Long startTime, Long endTime, String rsvp_status) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(4);
        ExtensibleClient.addParamIfNotBlankZero("uid", userId, params);
        ExtensibleClient.addParamDelimitIfNotBlankEmpty("eids", eventIds, params);
        ExtensibleClient.addParamIfNotBlankZero("start_time", startTime, params);
        ExtensibleClient.addParamIfNotBlankZero("end_time", endTime, params);
        return this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET, params);
    }

    @Override
    public T events_getMembers(Long eventId) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET_MEMBERS, ExtensibleClient.newPair("eid", eventId));
    }

    @Override
    public Long events_create(Map<String, String> event_info) throws FacebookException {
        return this.extractLong(this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET_CREATE, ExtensibleClient.newPair("event_info", new JSONObject(event_info))));
    }

    @Override
    public boolean events_edit(Long eid, Map<String, String> event_info) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET_EDIT, ExtensibleClient.newPair("eid", eid), ExtensibleClient.newPair("event_info", new JSONObject(event_info))));
    }

    @Override
    public boolean events_cancel(Long eid, String cancel_message) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET_CANCEL, ExtensibleClient.newPair("eid", eid), ExtensibleClient.newPair("cancel_message", cancel_message)));
    }

    @Override
    public boolean events_rsvp(Long eid, String rsvp_status) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.EVENTS_GET_RSVP, ExtensibleClient.newPair("eid", eid), ExtensibleClient.newPair("rsvp_status", rsvp_status)));
    }

    @Override
    public boolean sms_canSend() throws FacebookException {
        return this.sms_canSend(this.users_getLoggedInUser());
    }

    @Override
    public boolean sms_canSend(Long userId) throws FacebookException {
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.SMS_CAN_SEND, ExtensibleClient.newPair("uid", userId)));
    }

    @Override
    public Integer sms_send(String message, Integer smsSessionId, boolean makeNewSession) throws FacebookException {
        return this.sms_send(this.users_getLoggedInUser(), message, smsSessionId, makeNewSession);
    }

    @Override
    public Integer sms_send(Long userId, String message, Integer smsSessionId, boolean makeNewSession) throws FacebookException {
        if (smsSessionId != null && smsSessionId != 0) {
            return this.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.SMS_SEND_MESSAGE, ExtensibleClient.newPair("uid", userId), ExtensibleClient.newPair("message", message), ExtensibleClient.newPair("session_id", smsSessionId), ExtensibleClient.newPair("req_session", makeNewSession)));
        }
        return this.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.SMS_SEND_MESSAGE, ExtensibleClient.newPair("uid", userId), ExtensibleClient.newPair("message", message), ExtensibleClient.newPair("req_session", makeNewSession)));
    }

    @Override
    public void sms_sendMessage(Long userId, CharSequence message) throws FacebookException {
        this.sms_send(userId, ((Object)message).toString(), null, false);
    }

    @Override
    public int sms_sendMessageWithSession(Long userId, CharSequence message) throws FacebookException {
        return this.sms_send(userId, ((Object)message).toString(), null, true);
    }

    @Override
    public T connect_registerUsers(Collection<Map<String, String>> accounts) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.CONNECT_REGISTER_USERS, ExtensibleClient.newPair("accounts", ExtensibleClient.toJsonListOfMaps(accounts)));
    }

    @Override
    public T connect_unregisterUsers(Collection<String> email_hashes) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.CONNECT_UNREGISTER_USERS, ExtensibleClient.newPair("accounts", ExtensibleClient.toJsonListOfStrings(email_hashes)));
    }

    @Override
    public int connect_getUnconnectedFriendsCount() throws FacebookException {
        return this.extractInt(this.callMethod((IFacebookMethod)FacebookMethod.CONNECT_GET_UNCONNECTED_FRIENDS_COUNT, new Pair[0]));
    }

    @Override
    public T photos_get(Iterable<Long> photoIds) throws FacebookException {
        return this.photos_get(null, null, photoIds);
    }

    @Override
    public T photos_get(Long subjId, Long albumId) throws FacebookException {
        return this.photos_get(subjId, albumId, null);
    }

    @Override
    public T photos_get(Long subjId, Iterable<Long> photoIds) throws FacebookException {
        return this.photos_get(subjId, null, photoIds);
    }

    @Override
    public T photos_get(Long subjId) throws FacebookException {
        return this.photos_get(subjId, null, null);
    }

    @Override
    public T photos_get(Long subjId, Long albumId, Iterable<Long> photoIds) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(3);
        ExtensibleClient.addParamIfNotBlankZero("subj_id", subjId, params);
        ExtensibleClient.addParamIfNotBlankZero("aid", albumId, params);
        ExtensibleClient.addParamDelimitIfNotBlankEmpty("pids", photoIds, params);
        if (params.isEmpty()) {
            throw new IllegalArgumentException("At least one of photoIds, albumId, or subjId must be provided");
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET, params);
    }

    @Override
    public T photos_getTags(Iterable<Long> photoIds) throws FacebookException {
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_TAGS, ExtensibleClient.newPair("pids", ExtensibleClient.delimit(photoIds)));
    }

    @Override
    public boolean photos_addTag(Long photoId, CharSequence tagText, Double xPct, Double yPct) throws FacebookException {
        return this.photos_addTag(photoId, xPct, yPct, null, tagText);
    }

    private boolean photos_addTag(Long photoId, Double xPct, Double yPct, Long taggedUserId, CharSequence tagText) throws FacebookException {
        assert (null != photoId && !photoId.equals(0));
        assert (null != taggedUserId || null != tagText);
        assert (null != xPct && xPct >= 0.0 && xPct <= 100.0);
        assert (null != yPct && yPct >= 0.0 && yPct <= 100.0);
        Pair<String, CharSequence> tagData = taggedUserId != null ? ExtensibleClient.newPair("tag_uid", taggedUserId) : ExtensibleClient.newPair("tag_text", tagText);
        T d = this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG, ExtensibleClient.newPair("pid", photoId), tagData, ExtensibleClient.newPair("x", xPct), ExtensibleClient.newPair("y", yPct));
        return this.extractBoolean(d);
    }

    @Override
    public T photos_createAlbum(String albumName) throws FacebookException {
        return this.photos_createAlbum(albumName, null, null);
    }

    @Override
    public boolean photos_addTag(Long photoId, Long taggedUserId, Double xPct, Double yPct) throws FacebookException {
        return this.photos_addTag(photoId, xPct, yPct, taggedUserId, null);
    }

    @Override
    public T photos_addTags(Long photoId, Iterable<PhotoTag> tags) throws FacebookException {
        JSONArray jsonTags = new JSONArray();
        for (PhotoTag tag : tags) {
            jsonTags.put((Object)tag.jsonify());
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG, ExtensibleClient.newPair("pid", photoId), ExtensibleClient.newPair("tags", jsonTags));
    }

    @Override
    public T photos_createAlbum(String name, String description, String location) throws FacebookException {
        assert (null != name && !"".equals(name));
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(3);
        params.add(ExtensibleClient.newPair("name", name));
        if (null != description) {
            params.add(ExtensibleClient.newPair("description", description));
        }
        if (null != location) {
            params.add(ExtensibleClient.newPair("location", location));
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_CREATE_ALBUM, params);
    }

    @Override
    public T photos_getAlbums(Iterable<Long> albumIds) throws FacebookException {
        return this.photos_getAlbums(null, albumIds);
    }

    @Override
    public T photos_getAlbums(Long userId) throws FacebookException {
        return this.photos_getAlbums(userId, null);
    }

    @Override
    public T photos_getAlbums(Long userId, Iterable<Long> albumIds) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(2);
        ExtensibleClient.addParamIfNotBlankZero("uid", userId, params);
        ExtensibleClient.addParamDelimitIfNotBlankEmpty("aids", albumIds, params);
        if (params.isEmpty()) {
            throw new FacebookException(ErrorCode.GEN_INVALID_PARAMETER, "Atleast one of userId or albumIds is required.");
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_GET_ALBUMS, params);
    }

    @Override
    public T photos_getByAlbum(Long albumId, Iterable<Long> photoIds) throws FacebookException {
        return this.photos_get(null, albumId, photoIds);
    }

    @Override
    public T photos_getByAlbum(Long albumId) throws FacebookException {
        return this.photos_get(null, albumId, null);
    }

    private boolean photos_addTag(Long photoId, Double xPct, Double yPct, Long taggedUserId, CharSequence tagText, Long userId) throws FacebookException {
        assert (null != photoId && !photoId.equals(0));
        assert (null != taggedUserId || null != tagText);
        assert (null != xPct && xPct >= 0.0 && xPct <= 100.0);
        assert (null != yPct && yPct >= 0.0 && yPct <= 100.0);
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(5);
        if (taggedUserId != null) {
            params.add(ExtensibleClient.newPair("tag_uid", taggedUserId));
        } else {
            params.add(ExtensibleClient.newPair("tag_text", tagText));
        }
        params.add(ExtensibleClient.newPair("x", xPct));
        params.add(ExtensibleClient.newPair("y", yPct));
        params.add(ExtensibleClient.newPair("pid", photoId));
        params.add(ExtensibleClient.newPair("owner_uid", userId));
        return this.extractBoolean(this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG_NOSESSION, params));
    }

    @Override
    public boolean photos_addTag(Long photoId, Long taggedUserId, Double pct, Double pct2, Long userId) throws FacebookException {
        return this.photos_addTag(photoId, pct, pct2, taggedUserId, null, userId);
    }

    @Override
    public boolean photos_addTag(Long photoId, CharSequence tagText, Double pct, Double pct2, Long userId) throws FacebookException {
        return this.photos_addTag(photoId, pct, pct2, null, tagText);
    }

    @Override
    public T photos_createAlbum(String albumName, Long userId) throws FacebookException {
        return this.photos_createAlbum(albumName, null, null, userId);
    }

    @Override
    public T photos_createAlbum(String name, String description, String location, Long userId) throws FacebookException {
        assert (null != name && !"".equals(name));
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(4);
        params.add(ExtensibleClient.newPair("name", name));
        if (null != description) {
            params.add(ExtensibleClient.newPair("description", description));
        }
        if (null != location) {
            params.add(ExtensibleClient.newPair("location", location));
        }
        params.add(ExtensibleClient.newPair("uid", userId));
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_CREATE_ALBUM_NOSESSION, params);
    }

    @Override
    public T photos_addTags(Long photoId, Iterable<PhotoTag> tags, Long userId) throws FacebookException {
        String tagStr = null;
        try {
            JSONArray jsonTags = new JSONArray();
            for (PhotoTag tag : tags) {
                jsonTags.put((Object)tag.jsonify());
            }
            tagStr = jsonTags.toString();
        }
        catch (Exception ex) {
            throw ExtensibleClient.runtimeException(ex);
        }
        return this.callMethod((IFacebookMethod)FacebookMethod.PHOTOS_ADD_TAG_NOSESSION, ExtensibleClient.newPair("pid", photoId), ExtensibleClient.newPair("tags", tagStr), ExtensibleClient.newPair("uid", userId));
    }

    @Override
    public T photos_upload(File photo) throws FacebookException {
        return this.photos_upload(photo, null, null);
    }

    @Override
    public T photos_upload(File photo, String caption) throws FacebookException {
        return this.photos_upload(photo, caption, null);
    }

    @Override
    public T photos_upload(File photo, Long albumId) throws FacebookException {
        return this.photos_upload(photo, null, albumId);
    }

    @Override
    public T photos_upload(File photo, String caption, Long albumId) throws FacebookException {
        return this.photos_upload(null, photo, caption, albumId);
    }

    @Override
    public T photos_upload(Long userId, File photo) throws FacebookException {
        return this.photos_upload(userId, photo, null, null);
    }

    @Override
    public T photos_upload(Long userId, File photo, String caption) throws FacebookException {
        return this.photos_upload(userId, photo, caption, null);
    }

    @Override
    public T photos_upload(Long userId, File photo, Long albumId) throws FacebookException {
        return this.photos_upload(userId, photo, null, albumId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T photos_upload(Long userId, File photo, String caption, Long albumId) throws FacebookException {
        try {
            FileInputStream fileInputStream = new FileInputStream(photo);
            BufferedInputStream fileStream = new BufferedInputStream(fileInputStream);
            try {
                T t = this.photos_upload(userId, caption, albumId, photo.getName(), fileStream);
                return t;
            }
            finally {
                ExtensibleClient.close(fileStream);
                ExtensibleClient.close(fileInputStream);
            }
        }
        catch (IOException ex) {
            throw ExtensibleClient.runtimeException(ex);
        }
    }

    @Override
    public T photos_upload(Long userId, String caption, Long albumId, String fileName, InputStream fileStream) throws FacebookException {
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(3);
        ExtensibleClient.addParamIfNotBlankZero("aid", albumId, params);
        ExtensibleClient.addParamIfNotBlank("caption", caption, params);
        boolean uid = ExtensibleClient.addParamIfNotBlankZero("uid", userId, params);
        FacebookMethod method = uid ? FacebookMethod.PHOTOS_UPLOAD_NOSESSION : FacebookMethod.PHOTOS_UPLOAD;
        return this.callMethod((IFacebookMethod)method, params, fileName, fileStream);
    }

    @Override
    public T notifications_sendEmail(Collection<Long> recipients, CharSequence subject, CharSequence text, CharSequence fbml) throws FacebookException {
        FacebookMethod method = this.isDesktop() ? FacebookMethod.NOTIFICATIONS_SEND_EMAIL_SESSION : FacebookMethod.NOTIFICATIONS_SEND_EMAIL_NOSESSION;
        ArrayList<Pair<String, CharSequence>> params = new ArrayList<Pair<String, CharSequence>>(4);
        ExtensibleClient.addParam("recipients", ExtensibleClient.delimit(recipients), params);
        ExtensibleClient.addParam("subject", subject, params);
        ExtensibleClient.addParamIfNotBlank("text", text, params);
        ExtensibleClient.addParamIfNotBlank("fbml", fbml, params);
        return this.callMethod((IFacebookMethod)method, params);
    }

    @Override
    public T notifications_sendFbmlEmail(Collection<Long> recipients, String subject, String fbml) throws FacebookException {
        return this.notifications_sendEmail(recipients, subject, null, fbml);
    }

    @Override
    public T notifications_sendTextEmail(Collection<Long> recipients, String subject, String email) throws FacebookException {
        return this.notifications_sendEmail(recipients, subject, email, null);
    }

    @Override
    public T notifications_sendEmailToCurrentUser(String subject, String email, String fbml) throws FacebookException {
        return this.notifications_sendEmail(Arrays.asList(this.users_getLoggedInUser()), subject, email, fbml);
    }

    @Override
    public T notifications_sendFbmlEmailToCurrentUser(String subject, String fbml) throws FacebookException {
        return this.notifications_sendEmailToCurrentUser(subject, null, fbml);
    }

    @Override
    public T notifications_sendTextEmailToCurrentUser(String subject, String email) throws FacebookException {
        return this.notifications_sendEmailToCurrentUser(subject, email, null);
    }

    @Override
    @Deprecated
    public String notifications_sendEmailStr(Collection<Long> recipients, CharSequence subject, CharSequence fbml, CharSequence text) throws FacebookException {
        return this.extractString(this.notifications_sendEmail(recipients, subject, text, fbml));
    }

    @Override
    @Deprecated
    public String notifications_sendEmail(Collection<Long> recipients, CharSequence subject, CharSequence fbml) throws FacebookException {
        return this.notifications_sendEmailStr(recipients, subject, fbml, null);
    }

    @Override
    @Deprecated
    public String notifications_sendEmailPlain(Collection<Long> recipients, CharSequence subject, CharSequence text) throws FacebookException {
        return this.notifications_sendEmailStr(recipients, subject, null, text);
    }

    static {
        try {
            SERVER_URL = new URL("http://api.facebook.com/restserver.php");
            HTTPS_SERVER_URL = new URL("https://api.facebook.com/restserver.php");
        }
        catch (MalformedURLException ex) {
            log.error((Object)("MalformedURLException: " + ex.getMessage()), (Throwable)ex);
        }
    }
}

