/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ldap.transaction.compensating;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.naming.directory.DirContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapOperations;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.transaction.compensating.BindOperationRecorder;
import org.springframework.ldap.transaction.compensating.LdapTransactionUtils;
import org.springframework.ldap.transaction.compensating.ModifyAttributesOperationRecorder;
import org.springframework.ldap.transaction.compensating.NullOperationRecorder;
import org.springframework.ldap.transaction.compensating.RebindOperationRecorder;
import org.springframework.ldap.transaction.compensating.RenameOperationRecorder;
import org.springframework.ldap.transaction.compensating.TempEntryRenamingStrategy;
import org.springframework.ldap.transaction.compensating.UnbindOperationRecorder;
import org.springframework.transaction.compensating.CompensatingTransactionOperationFactory;
import org.springframework.transaction.compensating.CompensatingTransactionOperationRecorder;

public class LdapCompensatingTransactionOperationFactory
implements CompensatingTransactionOperationFactory {
    private static Log log = LogFactory.getLog((Class)(class$org$springframework$ldap$transaction$compensating$LdapCompensatingTransactionOperationFactory == null ? (class$org$springframework$ldap$transaction$compensating$LdapCompensatingTransactionOperationFactory = LdapCompensatingTransactionOperationFactory.class$("org.springframework.ldap.transaction.compensating.LdapCompensatingTransactionOperationFactory")) : class$org$springframework$ldap$transaction$compensating$LdapCompensatingTransactionOperationFactory));
    private TempEntryRenamingStrategy renamingStrategy;
    static /* synthetic */ Class class$org$springframework$ldap$transaction$compensating$LdapCompensatingTransactionOperationFactory;
    static /* synthetic */ Class class$org$springframework$ldap$core$DirContextProxy;

    public LdapCompensatingTransactionOperationFactory(TempEntryRenamingStrategy renamingStrategy) {
        this.renamingStrategy = renamingStrategy;
    }

    public CompensatingTransactionOperationRecorder createRecordingOperation(Object resource, String operation) {
        if (StringUtils.equals((String)operation, (String)"bind")) {
            log.debug((Object)"Bind operation recorded");
            return new BindOperationRecorder(this.createLdapOperationsInstance((DirContext)resource));
        }
        if (StringUtils.equals((String)operation, (String)"rebind")) {
            log.debug((Object)"Rebind operation recorded");
            return new RebindOperationRecorder(this.createLdapOperationsInstance((DirContext)resource), this.renamingStrategy);
        }
        if (StringUtils.equals((String)operation, (String)"rename")) {
            log.debug((Object)"Rename operation recorded");
            return new RenameOperationRecorder(this.createLdapOperationsInstance((DirContext)resource));
        }
        if (StringUtils.equals((String)operation, (String)"modifyAttributes")) {
            return new ModifyAttributesOperationRecorder(this.createLdapOperationsInstance((DirContext)resource));
        }
        if (StringUtils.equals((String)operation, (String)"unbind")) {
            return new UnbindOperationRecorder(this.createLdapOperationsInstance((DirContext)resource), this.renamingStrategy);
        }
        log.warn((Object)("No suitable CompensatingTransactionOperationRecorder found for method " + operation + ". Operation will not be transacted."));
        return new NullOperationRecorder();
    }

    LdapOperations createLdapOperationsInstance(DirContext ctx) {
        return new LdapTemplate(new SingleContextSource(ctx));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class NonClosingDirContextInvocationHandler
    implements InvocationHandler {
        private DirContext target;

        public NonClosingDirContextInvocationHandler(DirContext target) {
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals("getTargetContext")) {
                return this.target;
            }
            if (methodName.equals("equals")) {
                return proxy == args[0] ? Boolean.TRUE : Boolean.FALSE;
            }
            if (methodName.equals("hashCode")) {
                return new Integer(proxy.hashCode());
            }
            if (methodName.equals("close")) {
                return null;
            }
            try {
                return method.invoke((Object)this.target, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
    }

    static class SingleContextSource
    implements ContextSource {
        private DirContext ctx;

        public SingleContextSource(DirContext ctx) {
            this.ctx = ctx;
        }

        public DirContext getReadOnlyContext() throws NamingException {
            return this.getNonClosingDirContextProxy(this.ctx);
        }

        public DirContext getReadWriteContext() throws NamingException {
            return this.getNonClosingDirContextProxy(this.ctx);
        }

        private DirContext getNonClosingDirContextProxy(DirContext context) {
            return (DirContext)Proxy.newProxyInstance((class$org$springframework$ldap$core$DirContextProxy == null ? (class$org$springframework$ldap$core$DirContextProxy = LdapCompensatingTransactionOperationFactory.class$("org.springframework.ldap.core.DirContextProxy")) : class$org$springframework$ldap$core$DirContextProxy).getClassLoader(), new Class[]{LdapTransactionUtils.getActualTargetClass(context), class$org$springframework$ldap$core$DirContextProxy == null ? (class$org$springframework$ldap$core$DirContextProxy = LdapCompensatingTransactionOperationFactory.class$("org.springframework.ldap.core.DirContextProxy")) : class$org$springframework$ldap$core$DirContextProxy}, (InvocationHandler)new NonClosingDirContextInvocationHandler(context));
        }
    }
}

