/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.userdetails.ldap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.naming.Name;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.ldap.LdapUserDetails;
import org.springframework.security.util.AuthorityUtils;
import org.springframework.util.Assert;

public class LdapUserDetailsImpl
implements LdapUserDetails {
    private Attributes attributes = new BasicAttributes();
    private String dn;
    private String password;
    private String username;
    private GrantedAuthority[] authorities = AuthorityUtils.NO_AUTHORITIES;
    private boolean accountNonExpired = true;
    private boolean accountNonLocked = true;
    private boolean credentialsNonExpired = true;
    private boolean enabled = true;

    protected LdapUserDetailsImpl() {
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public GrantedAuthority[] getAuthorities() {
        return this.authorities;
    }

    public String getDn() {
        return this.dn;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean isAccountNonExpired() {
        return this.accountNonExpired;
    }

    public boolean isAccountNonLocked() {
        return this.accountNonLocked;
    }

    public boolean isCredentialsNonExpired() {
        return this.credentialsNonExpired;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString()).append(": ");
        sb.append("Username: ").append(this.username).append("; ");
        sb.append("Password: [PROTECTED]; ");
        sb.append("Enabled: ").append(this.enabled).append("; ");
        sb.append("AccountNonExpired: ").append(this.accountNonExpired).append("; ");
        sb.append("credentialsNonExpired: ").append(this.credentialsNonExpired).append("; ");
        sb.append("AccountNonLocked: ").append(this.accountNonLocked).append("; ");
        if (this.getAuthorities() != null) {
            sb.append("Granted Authorities: ");
            for (int i = 0; i < this.getAuthorities().length; ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.getAuthorities()[i].toString());
            }
        } else {
            sb.append("Not granted any authorities");
        }
        return sb.toString();
    }

    static /* synthetic */ GrantedAuthority[] access$102(LdapUserDetailsImpl x0, GrantedAuthority[] x1) {
        x0.authorities = x1;
        return x1;
    }

    public static class Essence {
        protected LdapUserDetailsImpl instance = this.createTarget();
        private List mutableAuthorities = new ArrayList();

        public Essence() {
        }

        public Essence(DirContextOperations ctx) {
            this.setDn(ctx.getDn());
        }

        public Essence(LdapUserDetails copyMe) {
            this.setDn(copyMe.getDn());
            this.setAttributes(copyMe.getAttributes());
            this.setUsername(copyMe.getUsername());
            this.setPassword(copyMe.getPassword());
            this.setEnabled(copyMe.isEnabled());
            this.setAccountNonExpired(copyMe.isAccountNonExpired());
            this.setCredentialsNonExpired(copyMe.isCredentialsNonExpired());
            this.setAccountNonLocked(copyMe.isAccountNonLocked());
            this.setAuthorities(copyMe.getAuthorities());
        }

        protected LdapUserDetailsImpl createTarget() {
            return new LdapUserDetailsImpl();
        }

        public void addAuthority(GrantedAuthority a) {
            if (!this.hasAuthority(a)) {
                this.mutableAuthorities.add(a);
            }
        }

        private boolean hasAuthority(GrantedAuthority a) {
            Iterator authorities = this.mutableAuthorities.iterator();
            while (authorities.hasNext()) {
                GrantedAuthority authority = (GrantedAuthority)authorities.next();
                if (!authority.equals(a)) continue;
                return true;
            }
            return false;
        }

        public LdapUserDetails createUserDetails() {
            Assert.notNull((Object)this.instance, (String)"Essence can only be used to create a single instance");
            Assert.notNull((Object)this.instance.username, (String)"username must not be null");
            Assert.notNull((Object)this.instance.getDn(), (String)"Distinguished name must not be null");
            LdapUserDetailsImpl.access$102(this.instance, this.getGrantedAuthorities());
            LdapUserDetailsImpl newInstance = this.instance;
            this.instance = null;
            return newInstance;
        }

        public GrantedAuthority[] getGrantedAuthorities() {
            return this.mutableAuthorities.toArray(new GrantedAuthority[0]);
        }

        public void setAccountNonExpired(boolean accountNonExpired) {
            this.instance.accountNonExpired = accountNonExpired;
        }

        public void setAccountNonLocked(boolean accountNonLocked) {
            this.instance.accountNonLocked = accountNonLocked;
        }

        public void setAttributes(Attributes attributes) {
            this.instance.attributes = attributes;
        }

        public void setAuthorities(GrantedAuthority[] authorities) {
            this.mutableAuthorities = new ArrayList<GrantedAuthority>(Arrays.asList(authorities));
        }

        public void setCredentialsNonExpired(boolean credentialsNonExpired) {
            this.instance.credentialsNonExpired = credentialsNonExpired;
        }

        public void setDn(String dn) {
            this.instance.dn = dn;
        }

        public void setDn(Name dn) {
            this.instance.dn = dn.toString();
        }

        public void setEnabled(boolean enabled) {
            this.instance.enabled = enabled;
        }

        public void setPassword(String password) {
            this.instance.password = password;
        }

        public void setUsername(String username) {
            this.instance.username = username;
        }
    }
}

