/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.annotation;

import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.annotation.Jsr250SecurityConfig;
import org.springframework.security.vote.AccessDecisionVoter;

public class Jsr250Voter
implements AccessDecisionVoter {
    public boolean supports(ConfigAttribute configAttribute) {
        return configAttribute instanceof Jsr250SecurityConfig;
    }

    public boolean supports(Class clazz) {
        return true;
    }

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition definition) {
        int result = 0;
        for (ConfigAttribute attribute : definition.getConfigAttributes()) {
            if (Jsr250SecurityConfig.PERMIT_ALL_ATTRIBUTE.equals(attribute)) {
                return 1;
            }
            if (Jsr250SecurityConfig.DENY_ALL_ATTRIBUTE.equals(attribute)) {
                return -1;
            }
            if (!this.supports(attribute)) continue;
            result = -1;
            for (GrantedAuthority authority : authentication.getAuthorities()) {
                if (!attribute.getAttribute().equals(authority.getAuthority())) continue;
                return 1;
            }
        }
        return result;
    }
}

