/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.facebookapi;

import com.google.code.facebookapi.ApplicationProperty;
import com.google.code.facebookapi.ExtensibleClient;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.json.JSONObject;

public class ApplicationPropertySet
implements Serializable {
    private Map<ApplicationProperty, Boolean> _attributesBool;
    private Map<ApplicationProperty, CharSequence> _attributesString;

    public ApplicationPropertySet() {
    }

    public ApplicationPropertySet(String jsonString) throws ClassCastException {
        Map<ApplicationProperty, String> mappings = ExtensibleClient.parseProperties(jsonString);
        Set<Map.Entry<ApplicationProperty, String>> entries = mappings.entrySet();
        for (Map.Entry<ApplicationProperty, String> entry : entries) {
            ApplicationProperty prop = entry.getKey();
            String value = entry.getValue();
            if (prop.isBooleanProperty()) {
                this.setBoolProperty(prop, "1".equals(value));
                continue;
            }
            if (!prop.isStringProperty()) continue;
            this.setStringProperty(prop, value);
        }
    }

    public void setBoolProperty(ApplicationProperty prop, boolean value) {
        if (null == prop || !prop.isBooleanProperty()) {
            throw new IllegalArgumentException("Boolean property expected");
        }
        if (null == this._attributesBool) {
            this._attributesBool = new TreeMap<ApplicationProperty, Boolean>();
        }
        this._attributesBool.put(prop, value);
    }

    public Boolean getBoolProperty(ApplicationProperty prop) {
        if (null == prop || !prop.isBooleanProperty()) {
            throw new IllegalArgumentException("Boolean property expected");
        }
        return null == this._attributesBool ? null : this._attributesBool.get((Object)prop);
    }

    public void setStringProperty(ApplicationProperty prop, CharSequence value) {
        if (null == prop || !prop.isStringProperty()) {
            throw new IllegalArgumentException("String property expected");
        }
        if (null == this._attributesString) {
            this._attributesString = new TreeMap<ApplicationProperty, CharSequence>();
        }
        this._attributesString.put(prop, value);
    }

    public CharSequence getStringProperty(ApplicationProperty prop) {
        if (null == prop || !prop.isStringProperty()) {
            throw new IllegalArgumentException("String property expected");
        }
        return null == this._attributesString ? null : this._attributesString.get((Object)prop);
    }

    public void removeProperty(ApplicationProperty prop) {
        if (prop.isBooleanProperty()) {
            this._attributesBool.remove((Object)prop);
        } else if (prop.isStringProperty()) {
            this._attributesString.remove((Object)prop);
        }
    }

    public boolean isEmpty() {
        return !(null != this._attributesString && !this._attributesString.isEmpty() || null != this._attributesBool && !this._attributesBool.isEmpty());
    }

    public JSONObject jsonify() {
        JSONObject ret = new JSONObject();
        if (null != this._attributesString) {
            for (Map.Entry<ApplicationProperty, CharSequence> entry : this._attributesString.entrySet()) {
                try {
                    ret.put(entry.getKey().propertyName(), (Object)((Object)entry.getValue()).toString());
                }
                catch (Exception ignored) {}
            }
        }
        if (null != this._attributesBool) {
            for (Map.Entry<ApplicationProperty, Object> entry : this._attributesBool.entrySet()) {
                try {
                    ret.put(entry.getKey().propertyName(), entry.getValue());
                }
                catch (Exception ignored) {}
            }
        }
        return ret;
    }

    public String toJsonString() {
        return this.jsonify().toString();
    }
}

