/*
 * Decompiled with CFR 0.152.
 */
package org.openxri;

import org.openxri.IRIUtils;
import org.openxri.ParseStream;
import org.openxri.XRIAuthority;
import org.openxri.XRISegment;
import org.openxri.XRef;

public class XRefAuthority
extends XRIAuthority {
    XRef moXRoot;

    public XRefAuthority(String sPath) {
        super(sPath);
        this.parse();
    }

    XRefAuthority() {
    }

    boolean doScan(ParseStream oStream) {
        if (oStream.empty()) {
            return false;
        }
        XRef oXRef = new XRef();
        ParseStream oTempStream = oStream.begin();
        if (!oXRef.scan(oTempStream)) {
            return false;
        }
        oStream.end(oTempStream);
        this.moXRoot = oXRef;
        XRISegment oSegment = new XRISegment(false, true, true);
        if (oSegment.scan(oStream)) {
            this.moSegment = oSegment;
        }
        return true;
    }

    public XRef getXRoot() {
        this.parse();
        return this.moXRoot;
    }

    public String toIRINormalForm() {
        String sValue = this.getXRoot().toIRINormalForm();
        if (this.moSegment != null) {
            sValue = sValue + this.moSegment.toIRINormalForm();
        }
        return sValue;
    }

    public String toURINormalForm() {
        return IRIUtils.IRItoURI(this.toIRINormalForm());
    }

    public String getRootAuthority() {
        return this.getXRoot().toString();
    }

    public XRIAuthority getParent() {
        this.parse();
        if (this.moSegment == null) {
            return null;
        }
        XRefAuthority oParent = new XRefAuthority();
        oParent.moXRoot = this.moXRoot;
        oParent.moSegment = this.moSegment.getParent();
        oParent.msValue = this.moXRoot.toString() + oParent.moSegment.toString();
        oParent.mbParsed = true;
        oParent.mbParseResult = this.mbParseResult;
        return oParent;
    }
}

