/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;

public class PrioritizedList {
    public static final int POLICY_RANDOMIZE = 1;
    public static final String PRIORITY_NULL = "null";
    private TreeMap sortedList = new TreeMap(new Item());

    public void addObject(String pPriority, Object o) {
        String priority = pPriority;
        if (priority == null || o == null) {
            return;
        }
        if (priority.equalsIgnoreCase(PRIORITY_NULL)) {
            priority = priority.toLowerCase();
        } else {
            long l = Long.parseLong(priority);
            if (l < 0L) {
                return;
            }
        }
        Item dbitem = (Item)this.sortedList.get(priority);
        if (dbitem != null) {
            dbitem.objects.add(o);
        } else {
            dbitem = new Item();
            dbitem.priority = priority;
            dbitem.objects.add(o);
            this.sortedList.put(priority, dbitem);
        }
    }

    public ArrayList getList() {
        ArrayList list = new ArrayList();
        Iterator i = this.sortedList.keySet().iterator();
        while (i.hasNext()) {
            String priority = (String)i.next();
            Item item = (Item)this.sortedList.get(priority);
            this.applyPolicy(item);
            list.addAll(item.objects);
        }
        return list;
    }

    private void applyPolicy(Item item) {
        if (!item.policyExecuted && item.objects.size() > 0) {
            Collections.shuffle(item.objects);
            item.policyExecuted = true;
        }
    }

    private class Item
    implements Comparator {
        String priority = "null";
        boolean policyExecuted = false;
        ArrayList objects = new ArrayList();

        private Item() {
        }

        public int compare(Object a, Object b) {
            long bPriority;
            if (a == null && b == null) {
                throw new IllegalArgumentException("arguments cannot be null");
            }
            if (!(a instanceof String) && !(b instanceof String)) {
                throw new IllegalArgumentException("arguments must be of type 'String'");
            }
            String aitem = (String)a;
            String bitem = (String)b;
            if (aitem.equalsIgnoreCase(bitem)) {
                return 0;
            }
            if (aitem.equals(PrioritizedList.PRIORITY_NULL)) {
                return 1;
            }
            if (bitem.equals(PrioritizedList.PRIORITY_NULL)) {
                return -1;
            }
            long aPriority = Long.parseLong(aitem);
            return aPriority < (bPriority = Long.parseLong(bitem)) ? -1 : 1;
        }
    }
}

