/*
 * Decompiled with CFR 0.152.
 */
package org.openxri.resolve;

import java.util.ArrayList;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openxri.XRIAbsolutePath;
import org.openxri.resolve.MimeType;
import org.openxri.xml.SEPElement;
import org.openxri.xml.SEPMediaType;
import org.openxri.xml.SEPPath;
import org.openxri.xml.SEPType;
import org.openxri.xml.Service;

public class SEPSelector {
    private static Log log = LogFactory.getLog((String)Service.class.getName());
    private ArrayList seps = null;
    private String matchTypeValue = null;
    private String matchMediaTypeValue = null;
    private String matchPathValue = null;
    private boolean matchedNonDefaultType = false;
    private boolean matchedNonDefaultMediaType = false;
    private boolean matchedNonDefaultPath = false;
    private ArrayList matchedPhase1List = null;
    private ArrayList indexes = new ArrayList();

    public SEPSelector(ArrayList pSeps) {
        this.seps = pSeps;
    }

    public void reset() {
        this.seps = null;
    }

    public ArrayList getSelectedSEPs(String type, String mediaType, String path) {
        this.matchTypeValue = type;
        this.matchMediaTypeValue = mediaType;
        this.matchPathValue = path;
        this.matchedNonDefaultType = false;
        this.matchedNonDefaultMediaType = false;
        this.matchedNonDefaultPath = false;
        this.matchedPhase1List = new ArrayList();
        this.applyMatchingRules();
        this.removeMatchDefaults();
        this.applySelectionRules();
        ArrayList returnList = new ArrayList();
        for (int i = 0; i < this.seps.size(); ++i) {
            Integer inx = new Integer(i);
            if (this.indexes.contains(inx)) continue;
            returnList.add(this.seps.get(i));
        }
        this.matchedPhase1List.clear();
        this.indexes.clear();
        return returnList;
    }

    private boolean applyMatchingRules() {
        try {
            for (int i = 0; i < this.seps.size(); ++i) {
                SEPElement element;
                int j;
                SEPElement element2;
                int j2;
                Service service = (Service)this.seps.get(i);
                service = (Service)service.clone();
                Vector<SEPElement> types = service.getTypes();
                Vector<SEPElement> mtypes = service.getMediaTypes();
                Vector<SEPElement> paths = service.getPaths();
                Vector elements = new Vector();
                if (types.size() == 0) {
                    SEPType type = new SEPType(null, "default", Boolean.FALSE);
                    service.addType(type);
                    types = service.getTypes();
                }
                if (mtypes.size() == 0) {
                    SEPMediaType mtype = new SEPMediaType(null, "default", Boolean.FALSE);
                    service.addMediaType(mtype);
                    mtypes = service.getMediaTypes();
                }
                if (paths.size() == 0) {
                    SEPPath path = new SEPPath(null, "default", Boolean.FALSE);
                    service.addPath(path);
                    paths = service.getPaths();
                }
                elements.addAll(service.getTypes());
                elements.addAll(service.getMediaTypes());
                elements.addAll(service.getPaths());
                boolean foundMatchNone = false;
                for (j2 = 0; j2 < elements.size(); ++j2) {
                    element2 = (SEPElement)elements.get(j2);
                    if (element2.getMatch() == null || !element2.getMatch().equals("none")) continue;
                    foundMatchNone = true;
                }
                if (foundMatchNone) {
                    this.matchedPhase1List.add(null);
                    continue;
                }
                for (j2 = 0; j2 < elements.size(); ++j2) {
                    element2 = (SEPElement)elements.get(j2);
                    if (element2.getMatch() != null && !element2.getMatch().equals("")) continue;
                    element2.setMatch("content");
                }
                Vector<SEPElement> output = new Vector<SEPElement>();
                for (j = 0; j < types.size(); ++j) {
                    element = (SEPElement)types.get(j);
                    if (element.getMatch().equals("default")) {
                        output.add(element);
                        continue;
                    }
                    if (!this.match(element)) continue;
                    this.matchedNonDefaultType = true;
                    output.add(element);
                }
                types = output;
                service.setTypes(types);
                output = new Vector();
                for (j = 0; j < mtypes.size(); ++j) {
                    element = (SEPElement)mtypes.get(j);
                    if (element.getMatch().equals("default")) {
                        output.add(element);
                        continue;
                    }
                    if (!this.match(element)) continue;
                    this.matchedNonDefaultMediaType = true;
                    output.add(element);
                }
                mtypes = output;
                service.setMediaTypes(mtypes);
                output = new Vector();
                for (j = 0; j < paths.size(); ++j) {
                    element = (SEPElement)paths.get(j);
                    if (element.getMatch().equals("default")) {
                        output.add(element);
                        continue;
                    }
                    if (!this.match(element)) continue;
                    this.matchedNonDefaultPath = true;
                    output.add(element);
                }
                paths = output;
                service.setPaths(paths);
                this.matchedPhase1List.add(service);
            }
        }
        catch (CloneNotSupportedException cnse) {
            log.error((Object)"This should not happen as we implemented Service.clone() - the only clone call we make here");
            throw new RuntimeException("Internal error: " + cnse.getMessage());
        }
        return true;
    }

    private boolean removeMatchDefaults() {
        for (int i = 0; i < this.matchedPhase1List.size(); ++i) {
            SEPElement element;
            int j;
            Service sep = (Service)this.matchedPhase1List.get(i);
            if (sep == null) continue;
            if (this.matchedNonDefaultType) {
                Vector<SEPElement> newTypes = new Vector<SEPElement>();
                for (j = 0; j < sep.getTypes().size(); ++j) {
                    element = (SEPElement)sep.getTypes().get(j);
                    if (!element.getMatch().equals("default")) {
                        newTypes.add(element);
                        continue;
                    }
                    log.trace((Object)("removeMatchDefaults - removing Type[" + j + "] from Service[" + i + "]"));
                }
                sep.setTypes(newTypes);
            }
            if (this.matchedNonDefaultPath) {
                Vector<SEPElement> newPaths = new Vector<SEPElement>();
                for (j = 0; j < sep.getPaths().size(); ++j) {
                    element = (SEPElement)sep.getPaths().get(j);
                    if (!element.getMatch().equals("default")) {
                        newPaths.add(element);
                        continue;
                    }
                    log.trace((Object)("removeMatchDefaults - removing Path[" + j + "] from Service[" + i + "]"));
                }
                sep.setPaths(newPaths);
            }
            if (!this.matchedNonDefaultMediaType) continue;
            Vector<SEPElement> newMediaTypes = new Vector<SEPElement>();
            for (j = 0; j < sep.getMediaTypes().size(); ++j) {
                element = (SEPElement)sep.getMediaTypes().get(j);
                if (!element.getMatch().equals("default")) {
                    newMediaTypes.add(element);
                    continue;
                }
                log.trace((Object)("removeMatchDefaults - removing MediaType[" + j + "] from Service[" + i + "]"));
            }
            sep.setMediaTypes(newMediaTypes);
        }
        return true;
    }

    private boolean applySelectionRules() {
        for (int i = 0; i < this.matchedPhase1List.size(); ++i) {
            Service sep = (Service)this.matchedPhase1List.get(i);
            if (sep == null) {
                log.debug((Object)("applySelectionRules - service[" + i + "] is inactive"));
                continue;
            }
            if (!this.canBeSelected(sep)) {
                log.debug((Object)("applySelectionRules - service[" + i + "] will not be selected"));
                this.indexes.add(new Integer(i));
                continue;
            }
            log.debug((Object)("applySelectionRules - service[" + i + "] is good to go"));
        }
        return true;
    }

    private Vector removeDefaultsIfPossible(Vector elements) {
        if (elements.size() <= 1) {
            return elements;
        }
        Vector<SEPElement> nonDefaultElements = new Vector<SEPElement>();
        Vector<SEPElement> defaultElements = new Vector<SEPElement>();
        boolean foundNonDefaultElement = false;
        for (int i = 0; i < elements.size(); ++i) {
            SEPElement element = (SEPElement)elements.get(i);
            if (element.getMatch().equalsIgnoreCase("default")) {
                if (foundNonDefaultElement) continue;
                defaultElements.add(element);
                continue;
            }
            nonDefaultElements.add(element);
            foundNonDefaultElement = true;
        }
        if (nonDefaultElements.size() > 0) {
            return nonDefaultElements;
        }
        return defaultElements;
    }

    private boolean canBeSelected(Service service) {
        Vector elements = new Vector();
        elements.addAll(service.getTypes());
        elements.addAll(service.getMediaTypes());
        elements.addAll(service.getPaths());
        boolean typeMatched = false;
        boolean mediaTypeMatched = false;
        boolean pathMatched = false;
        boolean selectService = false;
        for (int i = 0; i < elements.size(); ++i) {
            SEPElement element = (SEPElement)elements.get(i);
            if (element.getMatch().equals("none")) {
                return false;
            }
            if (element.getSelect()) {
                selectService = true;
            }
            if (element instanceof SEPType) {
                typeMatched = true;
                continue;
            }
            if (element instanceof SEPMediaType) {
                mediaTypeMatched = true;
                continue;
            }
            if (!(element instanceof SEPPath)) continue;
            pathMatched = true;
        }
        return selectService || typeMatched && mediaTypeMatched && pathMatched;
    }

    private boolean match(SEPElement element) {
        String elementMatch = element.getMatch();
        String elementValue = element.getValue();
        String matchElementValue = null;
        if (element instanceof SEPType) {
            matchElementValue = this.matchTypeValue;
        } else if (element instanceof SEPMediaType) {
            matchElementValue = this.matchMediaTypeValue;
        } else if (element instanceof SEPPath) {
            matchElementValue = this.matchPathValue;
        }
        if (elementMatch.equals("content")) {
            if (matchElementValue == null && elementValue == null) {
                return true;
            }
            if (matchElementValue != null && elementValue == null) {
                return false;
            }
            if (matchElementValue == null && elementValue != null) {
                return false;
            }
            return this.matchContent(element);
        }
        if (elementMatch.equals("any")) {
            return true;
        }
        if (elementMatch.equals("non-null")) {
            return matchElementValue != null && matchElementValue.length() != 0;
        }
        if (elementMatch.equals("null")) {
            return matchElementValue == null || matchElementValue.length() == 0;
        }
        if (elementMatch.equals("none")) {
            return false;
        }
        return false;
    }

    public boolean matchContent(SEPElement candidate) {
        if (candidate instanceof SEPType) {
            return this.matchContent((SEPType)candidate);
        }
        if (candidate instanceof SEPPath) {
            return this.matchContent((SEPPath)candidate);
        }
        if (candidate instanceof SEPMediaType) {
            return this.matchContent((SEPMediaType)candidate);
        }
        return false;
    }

    public boolean matchContent(SEPType type) {
        return this.matchTypeValue.equals(type.getValue());
    }

    public boolean matchContent(SEPPath path) {
        String xrdPath = this.trimPath(path.getValue());
        String inputPath = this.trimPath(this.matchPathValue);
        if (inputPath.equalsIgnoreCase(xrdPath)) {
            return true;
        }
        log.trace((Object)("xrdPath = '" + xrdPath + "'"));
        log.trace((Object)("inputPath = '" + inputPath + "'"));
        XRIAbsolutePath xrdAbsPath = new XRIAbsolutePath("/" + xrdPath);
        XRIAbsolutePath inputAbsPath = new XRIAbsolutePath("/" + inputPath);
        return xrdAbsPath.isPrefixOf(inputAbsPath);
    }

    public boolean matchContent(SEPMediaType mtype) {
        MimeType candidateMimeType = MimeType.parse(mtype.getValue());
        MimeType critMimeType = MimeType.parse(this.matchMediaTypeValue);
        return critMimeType.equals(candidateMimeType);
    }

    private String trimPath(String path) {
        char last;
        StringBuffer sb = new StringBuffer(path.trim());
        while (sb.length() > 0 && ((last = sb.charAt(sb.length() - 1)) == '/' || last == '*' || last == '!')) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

