/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Method;
import org.easymock.ArgumentsMatcher;
import org.easymock.IAnswer;
import org.easymock.internal.IMocksBehavior;
import org.easymock.internal.IMocksControlState;
import org.easymock.internal.Invocation;
import org.easymock.internal.LastControl;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.RuntimeExceptionWrapper;
import org.easymock.internal.ThrowableWrapper;

public class ReplayState
implements IMocksControlState {
    private IMocksBehavior behavior;

    public ReplayState(IMocksBehavior behavior) {
        this.behavior = behavior;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        Result result = this.behavior.addActual(invocation);
        LastControl.pushCurrentArguments(invocation.getArguments());
        try {
            Object object = result.answer();
            return object;
        }
        catch (Throwable t) {
            throw new ThrowableWrapper(t);
        }
        finally {
            LastControl.popCurrentArguments();
        }
    }

    public void verify() {
        this.behavior.verify();
    }

    public void replay() {
        this.throwWrappedIllegalStateException();
    }

    public void callback(Runnable runnable) {
        this.throwWrappedIllegalStateException();
    }

    public void checkOrder(boolean value) {
        this.throwWrappedIllegalStateException();
    }

    public void andReturn(Object value) {
        this.throwWrappedIllegalStateException();
    }

    public void andThrow(Throwable throwable) {
        this.throwWrappedIllegalStateException();
    }

    public void andAnswer(IAnswer answer) {
        this.throwWrappedIllegalStateException();
    }

    public void andStubReturn(Object value) {
        this.throwWrappedIllegalStateException();
    }

    public void andStubThrow(Throwable throwable) {
        this.throwWrappedIllegalStateException();
    }

    public void andStubAnswer(IAnswer answer) {
        this.throwWrappedIllegalStateException();
    }

    public void asStub() {
        this.throwWrappedIllegalStateException();
    }

    public void times(Range range) {
        this.throwWrappedIllegalStateException();
    }

    public void setMatcher(Method method, ArgumentsMatcher matcher) {
        this.throwWrappedIllegalStateException();
    }

    public void setDefaultMatcher(ArgumentsMatcher matcher) {
        this.throwWrappedIllegalStateException();
    }

    public void setDefaultReturnValue(Object value) {
        this.throwWrappedIllegalStateException();
    }

    public void setDefaultThrowable(Throwable throwable) {
        this.throwWrappedIllegalStateException();
    }

    public void setDefaultVoidCallable() {
        this.throwWrappedIllegalStateException();
    }

    private void throwWrappedIllegalStateException() {
        throw new RuntimeExceptionWrapper(new IllegalStateException("This method must not be called in replay state."));
    }

    public void assertRecordState() {
        this.throwWrappedIllegalStateException();
    }
}

