import org.codehaus.groovy.grails.plugins.springsecurity.Secured

class TaskTypeController extends BaseController {
    
    def index = { redirect(action:list,params:params) }

    // the delete, save and update actions only accept POST requests
    def allowedMethods = [delete:'POST', save:'POST', update:'POST']

    def list = {
        if(!params.max) params.max = 10
        [ taskTypeInstanceList: TaskType.list( params ) ]
    }

    def show = {
        def taskTypeInstance = TaskType.get( params.id )

        if(!taskTypeInstance) {
            flash.message = "TaskType not found with id ${params.id}"
            redirect(action:list)
        }
        else { return [ taskTypeInstance : taskTypeInstance ] }
    }

    def delete = {
        def taskTypeInstance = TaskType.get( params.id )
        if(taskTypeInstance) {
            taskTypeInstance.delete()
            flash.message = "TaskType ${params.id} deleted"
            redirect(action:list)
        }
        else {
            flash.message = "TaskType not found with id ${params.id}"
            redirect(action:list)
        }
    }

    def edit = {
        def taskTypeInstance = TaskType.get( params.id )

        if(!taskTypeInstance) {
            flash.message = "TaskType not found with id ${params.id}"
            redirect(action:list)
        }
        else {
            return [ taskTypeInstance : taskTypeInstance ]
        }
    }

    def update = {
        def taskTypeInstance = TaskType.get( params.id )
        if(taskTypeInstance) {
            taskTypeInstance.properties = params
            if(!taskTypeInstance.hasErrors() && taskTypeInstance.save()) {
                flash.message = "TaskType ${params.id} updated"
                redirect(action:show,id:taskTypeInstance.id)
            }
            else {
                render(view:'edit',model:[taskTypeInstance:taskTypeInstance])
            }
        }
        else {
            flash.message = "TaskType not found with id ${params.id}"
            redirect(action:edit,id:params.id)
        }
    }

    def create = {
        def taskTypeInstance = new TaskType()
        taskTypeInstance.properties = params
        return ['taskTypeInstance':taskTypeInstance]
    }

    def save = {
        def taskTypeInstance = new TaskType(params)
        if(!taskTypeInstance.hasErrors() && taskTypeInstance.save()) {
            flash.message = "TaskType ${taskTypeInstance.id} created"
            redirect(action:show,id:taskTypeInstance.id)
        }
        else {
            render(view:'create',model:[taskTypeInstance:taskTypeInstance])
        }
    }
}
